/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.engine.common.StepIdentifier;
import de.renew.engine.simulator.ConcurrentSimulator;
import de.renew.engine.simulator.NonConcurrentSimulator;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.engine.simulator.Simulator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class ParallelSimulator
implements Simulator {
    public static Logger logger = Logger.getLogger(ParallelSimulator.class);
    public final int multiplicity;
    protected long simulationRunId;
    private final Simulator[] simulators;

    public ParallelSimulator(int n, boolean bl) {
        boolean bl2;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (n == 0) {
            n = 1;
        }
        boolean bl3 = bl2 = n > 0;
        if (!bl2) {
            n = -n;
        }
        this.multiplicity = n;
        this.simulators = new Simulator[n];
        for (int i = 0; i < n; ++i) {
            this.simulators[i] = bl2 ? new ConcurrentSimulator(bl) : new NonConcurrentSimulator(bl);
        }
    }

    @Override
    public boolean isActive() {
        for (int i = 0; i < this.multiplicity; ++i) {
            if (!this.simulators[i].isActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void startRun() {
        SimulationThreadPool.getCurrent().executeAndWait(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < ParallelSimulator.this.multiplicity; ++i) {
                    ParallelSimulator.this.simulators[i].startRun();
                }
            }
        });
    }

    @Override
    public void stopRun() {
        SimulationThreadPool.getCurrent().executeAndWait(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < ParallelSimulator.this.multiplicity; ++i) {
                    ParallelSimulator.this.simulators[i].stopRun();
                }
            }
        });
    }

    @Override
    public synchronized void terminateRun() {
        SimulationThreadPool.getCurrent().executeAndWait(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < ParallelSimulator.this.multiplicity; ++i) {
                    ParallelSimulator.this.simulators[i].terminateRun();
                }
            }
        });
    }

    @Override
    public synchronized int step() {
        Future<Integer> future = SimulationThreadPool.getCurrent().submitAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int n;
                for (n = 0; n < ParallelSimulator.this.multiplicity; ++n) {
                    ParallelSimulator.this.simulators[n].stopRun();
                }
                n = 0;
                for (int i = 0; i < ParallelSimulator.this.multiplicity; ++i) {
                    n = ParallelSimulator.this.simulators[i].step();
                    if (n != 1 && n != 2) continue;
                    return n;
                }
                return n;
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return -1;
    }

    @Override
    public void refresh() {
        SimulationThreadPool.getCurrent().executeAndWait(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < ParallelSimulator.this.multiplicity; ++i) {
                    ParallelSimulator.this.simulators[i].refresh();
                }
            }
        });
    }

    @Override
    public boolean isSequential() {
        return false;
    }

    @Override
    public StepIdentifier nextStepIdentifier() {
        Future<StepIdentifier> future = SimulationThreadPool.getCurrent().submitAndWait(new Callable<StepIdentifier>(){

            @Override
            public StepIdentifier call() throws Exception {
                long[] lArray = new long[ParallelSimulator.this.simulators.length];
                for (int i = 0; i < ParallelSimulator.this.simulators.length; ++i) {
                    lArray[i] = ParallelSimulator.this.simulators[i].nextStepIdentifier().getComponents()[0];
                }
                return new StepIdentifier(ParallelSimulator.this.simulationRunId, lArray);
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }

    @Override
    public StepIdentifier currentStepIdentifier() {
        Future<StepIdentifier> future = SimulationThreadPool.getCurrent().submitAndWait(new Callable<StepIdentifier>(){

            @Override
            public StepIdentifier call() throws Exception {
                long[] lArray = new long[ParallelSimulator.this.simulators.length];
                for (int i = 0; i < ParallelSimulator.this.simulators.length; ++i) {
                    lArray[i] = ParallelSimulator.this.simulators[i].currentStepIdentifier().getComponents()[0];
                }
                return new StepIdentifier(ParallelSimulator.this.simulationRunId, lArray);
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }
}

