/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.database.TransactionSource;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.simulator.ExecuteFinder;
import de.renew.engine.simulator.OverallEarliestTimeFinder;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.engine.simulator.Simulator;
import de.renew.engine.simulator.SimulatorEventQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class SequentialSimulator
implements Simulator,
Runnable {
    public static Logger logger = Logger.getLogger(SequentialSimulator.class);
    private long simulationRunId;
    private long cycle = 0L;
    private ExecuteFinder finder;
    private Searcher searcher = new Searcher();
    private boolean stepFired = false;
    private boolean isAlive = false;
    private boolean wantBreak = false;
    private SequentialSimulator runThread = null;
    private boolean wantEventQueueDelay;

    public SequentialSimulator() {
        this(true);
    }

    public SequentialSimulator(boolean bl) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.wantEventQueueDelay = bl;
        this.findNewBinding();
    }

    @Override
    public boolean isActive() {
        return this.isAlive;
    }

    @Override
    public synchronized void startRun() {
        if (this.runThread == null) {
            this.runThread = this;
            SimulationThreadPool.getCurrent().execute(this);
            try {
                TransactionSource.simulationStateChanged(true, true);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    @Override
    public synchronized void stopRun() {
        SimulationThreadPool.getCurrent().executeAndWait(new Runnable(){

            @Override
            public void run() {
                while (SequentialSimulator.this.runThread != null) {
                    SequentialSimulator.this.wantBreak = true;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                try {
                    TransactionSource.simulationStateChanged(true, false);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        });
    }

    @Override
    public synchronized void terminateRun() {
        SimulationThreadPool.getCurrent().executeAndWait(new Runnable(){

            @Override
            public void run() {
                SequentialSimulator.this.stopRun();
                try {
                    TransactionSource.simulationStateChanged(false, false);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        });
    }

    private void fire() {
        this.stepFired = false;
        while (this.isAlive && !this.stepFired) {
            if (this.wantEventQueueDelay) {
                SimulatorEventQueue.awaitEmptyQueue();
            }
            this.stepFired = this.finder.execute(this.nextStepIdentifier(), false);
            this.findNewBinding();
        }
    }

    private void findNewBinding() {
        this.finder = new ExecuteFinder();
        while (!this.finder.isCompleted() && !SearchQueue.isTotallyEmpty()) {
            Searchable searchable = SearchQueue.extract();
            OverallEarliestTimeFinder overallEarliestTimeFinder = new OverallEarliestTimeFinder(this.finder);
            this.searcher.searchAndRecover(overallEarliestTimeFinder, searchable, searchable);
            overallEarliestTimeFinder.insertIntoSearchQueue(searchable);
        }
        this.isAlive = this.finder.isCompleted();
    }

    @Override
    public synchronized int step() {
        Future<Integer> future = SimulationThreadPool.getCurrent().submitAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                if (SequentialSimulator.this.runThread != null) {
                    SequentialSimulator.this.stopRun();
                    if (SequentialSimulator.this.isAlive && !SequentialSimulator.this.stepFired) {
                        SequentialSimulator.this.fire();
                    }
                } else {
                    SequentialSimulator.this.fire();
                }
                if (SequentialSimulator.this.stepFired) {
                    if (SequentialSimulator.this.isAlive) {
                        return 1;
                    }
                    return 2;
                }
                return 4;
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (!this.isAlive) {
            this.findNewBinding();
        }
        while (this.isAlive && !this.wantBreak) {
            Thread.yield();
            this.fire();
        }
        SequentialSimulator sequentialSimulator = this;
        synchronized (sequentialSimulator) {
            this.runThread = null;
            this.wantBreak = false;
            this.notifyAll();
        }
    }

    @Override
    public synchronized void refresh() {
        SimulationThreadPool.getCurrent().executeAndWait(new Runnable(){

            @Override
            public void run() {
                if (SequentialSimulator.this.runThread == null) {
                    SequentialSimulator.this.findNewBinding();
                }
            }
        });
    }

    @Override
    public boolean isSequential() {
        return true;
    }

    @Override
    public StepIdentifier nextStepIdentifier() {
        Future<StepIdentifier> future = SimulationThreadPool.getCurrent().submitAndWait(new Callable<StepIdentifier>(){

            @Override
            public StepIdentifier call() throws Exception {
                return new StepIdentifier(SequentialSimulator.this.simulationRunId, new long[]{++SequentialSimulator.this.cycle});
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }

    @Override
    public StepIdentifier currentStepIdentifier() {
        Future<StepIdentifier> future = SimulationThreadPool.getCurrent().submitAndWait(new Callable<StepIdentifier>(){

            @Override
            public StepIdentifier call() throws Exception {
                return new StepIdentifier(SequentialSimulator.this.simulationRunId, new long[]{SequentialSimulator.this.cycle});
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }
}

