/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.engine.simulator.BlockingSimulationCallable;
import de.renew.engine.simulator.BlockingSimulationRunnable;
import de.renew.util.ClassSource;
import de.renew.util.Semaphor;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class SimulationThreadPool
extends ThreadPoolExecutor {
    public static Logger logger = Logger.getLogger(SimulationThreadPool.class);
    private static final Object lock = new Object();
    private static SimulationThreadPool singleton = null;
    private static SimulationThreadPool newSingleton = null;
    private final SimulatorThreadFactory factory = (SimulatorThreadFactory)this.getThreadFactory();

    private SimulationThreadPool(int n) {
        super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new SimulatorThreadFactory());
    }

    public void executeAndWait(Runnable runnable) {
        if (this.isMyThread()) {
            logger.debug((Object)("Running simulation runnable directly: " + runnable));
            runnable.run();
        } else {
            Semaphor semaphor = new Semaphor();
            BlockingSimulationRunnable blockingSimulationRunnable = new BlockingSimulationRunnable(runnable, semaphor, Thread.currentThread());
            this.execute(blockingSimulationRunnable);
            logger.debug((Object)("Running simulation runnable indirectly: " + runnable));
            semaphor.P();
        }
        logger.debug((Object)("Running simulation runnable returned" + runnable));
    }

    public <T> Future<T> submitAndWait(Callable<T> callable) {
        Future<T> future = null;
        if (this.isMyThread()) {
            logger.debug((Object)("Running simulation callable directly: " + callable));
            future = new FutureTask<T>(callable);
            ((FutureTask)future).run();
        } else {
            Semaphor semaphor = new Semaphor();
            BlockingSimulationCallable<T> blockingSimulationCallable = new BlockingSimulationCallable<T>(callable, semaphor, Thread.currentThread());
            future = this.submit(blockingSimulationCallable);
            logger.debug((Object)("Running simulation callable indirectly: " + callable));
            semaphor.P();
        }
        logger.debug((Object)("Running simulation callable returned" + callable));
        return future;
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        FutureTask futureTask = callable instanceof BlockingSimulationCallable ? new WrappedFutureTask<T>((BlockingSimulationCallable)callable) : new FutureTask(callable);
        this.execute(futureTask);
        return futureTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimulationThreadPool getNew() {
        Object object = lock;
        synchronized (object) {
            if (newSingleton == null) {
                newSingleton = new SimulationThreadPool(5);
            }
            return newSingleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimulationThreadPool getCurrent() {
        Object object = lock;
        synchronized (object) {
            if (singleton == null) {
                singleton = new SimulationThreadPool(5);
            }
            return singleton;
        }
    }

    public static SimulationThreadPool getSimulationThreadPool() {
        return SimulationThreadPool.getCurrent();
    }

    public static boolean isSimulationThread() {
        return singleton != null && singleton.isMyThread();
    }

    public boolean isMyThread() {
        return Thread.currentThread().getThreadGroup().equals(this.factory.getThreadGroup());
    }

    public boolean isMyThread(Thread thread) {
        return thread.getThreadGroup().equals(this.factory.getThreadGroup());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cleanup() {
        Object object = lock;
        synchronized (object) {
            SimulationThreadPool simulationThreadPool = singleton;
            singleton = newSingleton;
            newSingleton = null;
            simulationThreadPool.shutdownNow();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void discardNew() {
        Object object = lock;
        synchronized (object) {
            SimulationThreadPool simulationThreadPool = newSingleton;
            newSingleton = null;
            simulationThreadPool.shutdown();
        }
    }

    public void setMaxPriority(int n) {
        this.factory.setMaxPriority(n);
    }

    public int getMaxPriority() {
        return this.factory.getMaxPriority();
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        SimulationThread simulationThread = (SimulationThread)thread;
        if (runnable instanceof BlockingSimulationRunnable) {
            simulationThread.setAncestor(((BlockingSimulationRunnable)runnable).getAncestor());
        } else if (runnable instanceof WrappedFutureTask) {
            WrappedFutureTask wrappedFutureTask = (WrappedFutureTask)runnable;
            simulationThread.setAncestor(wrappedFutureTask.callable.getAncestor());
        }
    }

    protected void afterExecute(Thread thread, Runnable runnable) {
        SimulationThread simulationThread = (SimulationThread)thread;
        simulationThread.setAncestor(null);
    }

    private class WrappedFutureTask<V>
    extends FutureTask<V> {
        BlockingSimulationCallable<V> callable;

        public WrappedFutureTask(BlockingSimulationCallable<V> blockingSimulationCallable) {
            super(blockingSimulationCallable);
            this.callable = blockingSimulationCallable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get() throws InterruptedException, ExecutionException {
            V v = null;
            try {
                v = ((FutureTask)super.get()).get();
            }
            catch (Exception exception) {
                if (exception instanceof InterruptedException) {
                    throw (InterruptedException)exception;
                }
                if (exception instanceof ExecutionException) {
                    throw (ExecutionException)exception;
                }
            }
            finally {
                this.callable.abort();
            }
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            V v = null;
            try {
                v = ((FutureTask)super.get(l, timeUnit)).get();
            }
            catch (Exception exception) {
                if (exception instanceof InterruptedException) {
                    throw (InterruptedException)exception;
                }
                if (exception instanceof ExecutionException) {
                    throw (ExecutionException)exception;
                }
                if (exception instanceof TimeoutException) {
                    throw (TimeoutException)exception;
                }
            }
            finally {
                this.callable.abort();
            }
            return v;
        }
    }

    static class SimulationThread
    extends Thread {
        private Thread ancestor;

        public SimulationThread(ThreadGroup threadGroup, Runnable runnable, String string, int n) {
            super(threadGroup, runnable, string, n);
        }

        private void setAncestor(Thread thread) {
            this.ancestor = thread;
        }

        public Thread getAncestor() {
            return this.ancestor;
        }
    }

    static class SimulatorThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;
        private int threadPriority;
        final ClassLoader classLoader;

        public SimulatorThreadFactory() {
            this(5);
        }

        public SimulatorThreadFactory(int n) {
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            while (threadGroup.getParent() != null) {
                threadGroup = threadGroup.getParent();
            }
            this.group = new ThreadGroup("simulation-thread-group");
            this.namePrefix = "simulation-thread-";
            this.threadPriority = n;
            this.classLoader = ClassSource.getClassLoader();
        }

        @Override
        public Thread newThread(Runnable runnable) {
            SimulationThread simulationThread = new SimulationThread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0);
            simulationThread.setContextClassLoader(this.classLoader);
            if (simulationThread.isDaemon()) {
                simulationThread.setDaemon(false);
            }
            if (simulationThread.getPriority() != 5) {
                simulationThread.setPriority(5);
            }
            assert (simulationThread.getThreadGroup().equals(this.getThreadGroup())) : "Thread must belong to thread group of factory";
            return simulationThread;
        }

        public ThreadGroup getThreadGroup() {
            return this.group;
        }

        public void setMaxPriority(int n) {
            this.group.setMaxPriority(n);
        }

        public int getMaxPriority() {
            return this.group.getMaxPriority();
        }
    }
}

