/*
 * Decompiled with CFR 0.152.
 */
package de.renew.expression;

import de.renew.expression.Expression;
import de.renew.expression.ExpressionWithTypeField;
import de.renew.expression.VariableMapper;
import de.renew.unify.CalculationChecker;
import de.renew.unify.Impossible;
import de.renew.unify.StateRecorder;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.Types;

public class EqualsExpression
extends ExpressionWithTypeField {
    Expression left;
    Expression right;

    public EqualsExpression(Class<?> clazz, Expression expression, Expression expression2) {
        super(clazz);
        this.left = expression;
        this.right = expression2;
    }

    @Override
    public boolean isInvertible() {
        return true;
    }

    @Override
    public Object startEvaluation(VariableMapper variableMapper, StateRecorder stateRecorder, CalculationChecker calculationChecker) throws Impossible {
        Variable variable = new Variable(this.left.startEvaluation(variableMapper, stateRecorder, calculationChecker), stateRecorder);
        Object object = this.right.startEvaluation(variableMapper, stateRecorder, calculationChecker);
        Unify.unify(variable, object, stateRecorder);
        return variable.getValue();
    }

    @Override
    public Object registerCalculation(VariableMapper variableMapper, StateRecorder stateRecorder, CalculationChecker calculationChecker) throws Impossible {
        Variable variable = new Variable(this.left.registerCalculation(variableMapper, stateRecorder, calculationChecker), stateRecorder);
        Object object = this.right.registerCalculation(variableMapper, stateRecorder, calculationChecker);
        calculationChecker.addCalculated(this.getType(), variable.getValue(), object, stateRecorder);
        return variable.getValue();
    }

    public String toString() {
        return "EqualsExpr(" + Types.typeToString((Class)this.getType()) + ": " + this.left + " = " + this.right + ")";
    }
}

