/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.expression.Expression;
import de.renew.expression.VariableMapper;
import de.renew.net.TokenSource;
import de.renew.unify.Impossible;
import de.renew.unify.StateRecorder;
import de.renew.unify.Unify;

public class ExpressionTokenSource
implements TokenSource {
    private Expression expression;
    private boolean trace;

    public ExpressionTokenSource(Expression expression) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.expression = expression;
        this.trace = true;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public boolean getTrace() {
        return this.trace;
    }

    @Override
    public Object createToken(VariableMapper variableMapper) throws Impossible {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        Object object = this.expression.startEvaluation(variableMapper, new StateRecorder(), null);
        if (!Unify.isBound(object)) {
            throw new Impossible("Cannot bind expression " + this.expression);
        }
        return object;
    }
}

