/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.net.TimeSet;
import de.renew.net.event.TokenEvent;
import de.renew.unify.Impossible;
import de.renew.util.DelayedFieldOwner;
import de.renew.util.Queue;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Set;
import java.util.Vector;

public class FIFOPlaceInstance
extends PlaceInstance {
    static final long serialVersionUID = 5987006166655815747L;
    private int tokenTests;
    private transient Queue<Object> tokenQueue;

    FIFOPlaceInstance(NetInstance netInstance, Place place, boolean bl) throws Impossible {
        super(netInstance, place, bl);
    }

    @Override
    protected void initTokenStorage() {
        this.tokenQueue = new Queue();
        this.tokenTests = 0;
    }

    private Set<Object> getFrontSet() {
        return Collections.singleton(this.tokenQueue.front());
    }

    @Override
    public Set<Object> getDistinctTokens() {
        if (this.tokenTests == 0 && !this.tokenQueue.isEmpty()) {
            return this.getFrontSet();
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Object> getDistinctTokens(Object object) {
        return this.getDistinctTokens();
    }

    @Override
    public Set<Object> getDistinctTestableTokens() {
        if (!this.tokenQueue.isEmpty()) {
            return this.getFrontSet();
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Object> getDistinctTestableTokens(Object object) {
        return this.getDistinctTestableTokens();
    }

    @Override
    public int getNumberOfTokens() {
        return this.tokenQueue.isEmpty() ? 0 : 1;
    }

    @Override
    public int getNumberOfTestedTokens() {
        return this.tokenTests == 0 ? 0 : 1;
    }

    @Override
    public boolean isEmpty() {
        return this.getNumberOfTokens() + this.getNumberOfTestedTokens() == 0;
    }

    @Override
    boolean containsToken(Object object) {
        return this.containsTestableToken(object) && this.tokenTests == 0;
    }

    @Override
    public int getTokenCount(Object object) {
        return this.containsToken(object) ? 1 : 0;
    }

    @Override
    public TimeSet getFreeTimeSet(Object object) {
        if (this.containsToken(object)) {
            return TimeSet.ZERO;
        }
        return TimeSet.EMPTY;
    }

    @Override
    public double computeEarliestTime(Object object, TimeSet timeSet) {
        return 0.0;
    }

    @Override
    public boolean containsTestedToken(Object object) {
        return this.containsTestableToken(object) && this.tokenTests > 0;
    }

    @Override
    public boolean containsTestableToken(Object object) {
        return this.tokenQueue.front().equals(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double removeToken(Object object, double d) throws Impossible {
        double d2;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.lock.lock();
        try {
            d2 = 0.0;
            if (!this.containsToken(object)) {
                throw new Impossible();
            }
            this.tokenQueue.dequeue();
            this.triggerables.proposeSearch();
            TokenEvent tokenEvent = new TokenEvent(this, object);
            this.listeners.tokenRemoved(tokenEvent);
            this.place.getListenerSet().tokenRemoved(tokenEvent);
            this.unreserve(object);
        }
        finally {
            this.lock.unlock();
        }
        return d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double testToken(Object object) throws Impossible {
        double d;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.lock.lock();
        try {
            boolean bl = false;
            d = 0.0;
            if (this.containsToken(object)) {
                if (this.tokenTests == 0) {
                    bl = true;
                }
                ++this.tokenTests;
            } else {
                throw new Impossible();
            }
            if (bl) {
                this.triggerables.proposeSearch();
                TokenEvent tokenEvent = new TokenEvent(this, object);
                this.listeners.tokenTested(tokenEvent);
                this.place.getListenerSet().tokenTested(tokenEvent);
            }
        }
        finally {
            this.lock.unlock();
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractAllTokens(Vector<Object> vector, Vector<Double> vector2) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.lock.lock();
        try {
            if (this.tokenTests == 0) {
                while (!this.tokenQueue.isEmpty()) {
                    Object object = this.tokenQueue.dequeue();
                    if (vector != null) {
                        vector.addElement(object);
                    }
                    if (vector2 == null) continue;
                    vector2.addElement(new Double(0.0));
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void insertToken(Object object, double d) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.internallyInsertToken(object, d, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void internallyInsertToken(Object object, double d, boolean bl) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.lock.lock();
        try {
            this.tokenQueue.enqueue(object);
            if (!bl) {
                this.reserve(object);
            }
            this.triggerables.proposeSearch();
            TokenEvent tokenEvent = new TokenEvent(this, object);
            this.listeners.tokenAdded(tokenEvent);
            this.place.getListenerSet().tokenAdded(tokenEvent);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void untestToken(Object object) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.lock.lock();
        try {
            if (this.containsTestedToken(object)) {
                --this.tokenTests;
                if (this.tokenTests == 0) {
                    this.triggerables.proposeSearch();
                    TokenEvent tokenEvent = new TokenEvent(this, object);
                    this.listeners.tokenUntested(tokenEvent);
                    this.place.getListenerSet().tokenUntested(tokenEvent);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RenewObjectOutputStream renewObjectOutputStream = null;
        if (objectOutputStream instanceof RenewObjectOutputStream) {
            renewObjectOutputStream = (RenewObjectOutputStream)objectOutputStream;
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.beginDomain((Object)this);
        }
        objectOutputStream.defaultWriteObject();
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.delayedWriteObject(this.tokenQueue, (DelayedFieldOwner)this);
            renewObjectOutputStream.endDomain((Object)this);
        } else {
            objectOutputStream.writeObject(this.tokenQueue);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        objectInputStream.defaultReadObject();
        if (!(objectInputStream instanceof RenewObjectInputStream)) {
            this.tokenQueue = (Queue)objectInputStream.readObject();
        }
    }

    @Override
    public void reassignField(Object object) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (!this.tryReassignField(object)) {
            if (object instanceof Queue) {
                this.tokenQueue = (Queue)object;
            } else {
                throw new NotSerializableException("Value of unexpected type given to FIFOPlaceInstance.reassign():" + object.getClass().getName() + ".");
            }
        }
    }

    protected void finalize() throws Throwable {
        while (!this.tokenQueue.isEmpty()) {
            Object object = this.tokenQueue.dequeue();
            this.unreserve(object);
        }
        super.finalize();
    }
}

