/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.FIFOPlaceInstance;
import de.renew.net.MultisetPlaceInstance;
import de.renew.net.Net;
import de.renew.net.NetElementID;
import de.renew.net.NetInstance;
import de.renew.net.PlaceInstance;
import de.renew.net.TokenSource;
import de.renew.net.event.PlaceEventListener;
import de.renew.net.event.PlaceEventListenerSet;
import de.renew.net.event.PlaceEventProducer;
import de.renew.unify.Impossible;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class Place
implements Serializable,
PlaceEventProducer {
    static final long serialVersionUID = 5661978821450640374L;
    public static final int MULTISETPLACE = 0;
    public static final int FIFOPLACE = 1;
    NetElementID id;
    String name;
    private boolean trace;
    Set<TokenSource> inscriptions;
    private int placetype = 0;
    private transient PlaceEventListenerSet listeners = new PlaceEventListenerSet();

    public Place(Net net, String string, NetElementID netElementID) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.id = netElementID;
        this.name = string;
        this.trace = true;
        this.inscriptions = new HashSet<TokenSource>();
        net.add(this);
    }

    public NetElementID getID() {
        return this.id;
    }

    public String toString() {
        return this.name;
    }

    public void setBehaviour(int n) {
        this.placetype = n;
    }

    PlaceInstance makeInstance(NetInstance netInstance, boolean bl) throws Impossible {
        PlaceInstance placeInstance = null;
        switch (this.placetype) {
            case 0: {
                placeInstance = new MultisetPlaceInstance(netInstance, this, bl);
                break;
            }
            case 1: {
                placeInstance = new FIFOPlaceInstance(netInstance, this, bl);
                break;
            }
            default: {
                throw new RuntimeException("Illegal place behaviour: " + this.placetype);
            }
        }
        return placeInstance;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public String getName() {
        return this.name;
    }

    public void add(TokenSource tokenSource) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.inscriptions.add(tokenSource);
    }

    public void remove(TokenSource tokenSource) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.inscriptions.remove(tokenSource);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RenewObjectOutputStream renewObjectOutputStream = null;
        if (objectOutputStream instanceof RenewObjectOutputStream) {
            renewObjectOutputStream = (RenewObjectOutputStream)objectOutputStream;
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.beginDomain((Object)this);
        }
        objectOutputStream.defaultWriteObject();
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.endDomain((Object)this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        objectInputStream.defaultReadObject();
        this.listeners = new PlaceEventListenerSet();
    }

    @Override
    public void addPlaceEventListener(PlaceEventListener placeEventListener) {
        this.listeners.addPlaceEventListener(placeEventListener);
    }

    @Override
    public void removePlaceEventListener(PlaceEventListener placeEventListener) {
        this.listeners.removePlaceEventListener(placeEventListener);
    }

    PlaceEventListenerSet getListenerSet() {
        return this.listeners;
    }
}

