/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.searchqueue.SearchQueue;
import de.renew.net.TimeSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class TokenBag
implements Serializable {
    private int size = 0;
    private Map<Object, TimeSet> map = new HashMap<Object, TimeSet>();

    TokenBag() {
    }

    public double computeEarliestTime(Object object, TimeSet timeSet) {
        if (this.map.containsKey(object)) {
            double d = this.map.get(object).computeEarliestTime(timeSet);
            return d;
        }
        if (timeSet.getSize() == 0) {
            return 0.0;
        }
        return Double.POSITIVE_INFINITY;
    }

    public synchronized TimeSet getTimeSet(Object object) {
        if (this.map.containsKey(object)) {
            return this.map.get(object);
        }
        return TimeSet.EMPTY;
    }

    public synchronized int getMultiplicity(Object object) {
        if (this.map.containsKey(object)) {
            return this.map.get(object).getSize();
        }
        return 0;
    }

    public synchronized Collection<Object> uniqueElements() {
        return new ArrayList<Object>(this.map.keySet());
    }

    public synchronized boolean includesAnytime(Object object) {
        return this.map.containsKey(object);
    }

    public synchronized boolean includesBefore(Object object, double d) {
        if (!this.map.containsKey(object)) {
            return false;
        }
        TimeSet timeSet = this.map.get(object);
        return d >= timeSet.earliestTime();
    }

    synchronized void add(Object object, double d) {
        if (this.map.containsKey(object)) {
            TimeSet timeSet = this.map.get(object);
            this.map.put(object, timeSet.including(d));
        } else {
            this.map.put(object, TimeSet.make(d));
        }
        ++this.size;
    }

    synchronized void removeOneOf(Object object, double d) {
        if (this.map.containsKey(object)) {
            TimeSet timeSet = this.map.get(object).excluding(d);
            if (timeSet.isEmpty()) {
                this.map.remove(object);
            } else {
                this.map.put(object, timeSet);
            }
            --this.size;
        } else {
            throw new RuntimeException("Negative number of tokens detected.");
        }
    }

    synchronized double removeWithDelay(Object object, double d) {
        if (this.map.containsKey(object)) {
            TimeSet timeSet = this.map.get(object);
            double d2 = timeSet.latestWithDelay(d, SearchQueue.getTime());
            if ((timeSet = timeSet.excluding(d2)).isEmpty()) {
                this.map.remove(object);
            } else {
                this.map.put(object, timeSet);
            }
            --this.size;
            return d2;
        }
        throw new NoSuchElementException();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TokenBag(size: ");
        stringBuffer.append(this.size);
        stringBuffer.append("; token@timeset:");
        for (Object object : this.map.keySet()) {
            stringBuffer.append(' ');
            stringBuffer.append(object);
            stringBuffer.append('@');
            stringBuffer.append(this.map.get(object));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

