/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.ManualInscription;
import de.renew.net.Net;
import de.renew.net.NetElementID;
import de.renew.net.TransitionInscription;
import de.renew.net.UplinkInscription;
import de.renew.net.event.TransitionEventListener;
import de.renew.net.event.TransitionEventListenerSet;
import de.renew.net.event.TransitionEventProducer;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class Transition
implements Serializable,
TransitionEventProducer {
    static final long serialVersionUID = -7955261691016471176L;
    NetElementID id;
    private final String name;
    private boolean trace;
    UplinkInscription uplink;
    Set<TransitionInscription> inscriptions;
    private transient TransitionEventListenerSet listeners = new TransitionEventListenerSet();

    public Transition(Net net, String string, NetElementID netElementID) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.id = netElementID;
        this.name = string;
        this.trace = true;
        this.uplink = null;
        this.inscriptions = new HashSet<TransitionInscription>();
        net.add(this);
    }

    public NetElementID getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public boolean isSpontaneous() {
        return this.uplink == null && !this.inscriptions.contains(ManualInscription.getInstance());
    }

    public boolean listensToChannel(String string) {
        return this.uplink != null && this.uplink.name.equals(string);
    }

    private void checkUplink() {
        this.uplink = null;
        for (TransitionInscription transitionInscription : this.inscriptions) {
            if (!(transitionInscription instanceof UplinkInscription)) continue;
            this.uplink = (UplinkInscription)transitionInscription;
        }
    }

    public void add(TransitionInscription transitionInscription) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (!this.inscriptions.contains(transitionInscription)) {
            this.inscriptions.add(transitionInscription);
            this.checkUplink();
        }
    }

    public void remove(TransitionInscription transitionInscription) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (this.inscriptions.contains(transitionInscription)) {
            this.inscriptions.remove(transitionInscription);
            this.checkUplink();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RenewObjectOutputStream renewObjectOutputStream = null;
        if (objectOutputStream instanceof RenewObjectOutputStream) {
            renewObjectOutputStream = (RenewObjectOutputStream)objectOutputStream;
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.beginDomain((Object)this);
        }
        objectOutputStream.defaultWriteObject();
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.endDomain((Object)this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        objectInputStream.defaultReadObject();
        this.listeners = new TransitionEventListenerSet();
    }

    @Override
    public void addTransitionEventListener(TransitionEventListener transitionEventListener) {
        this.listeners.addTransitionEventListener(transitionEventListener);
    }

    @Override
    public void removeTransitionEventListener(TransitionEventListener transitionEventListener) {
        this.listeners.removeTransitionEventListener(transitionEventListener);
    }

    TransitionEventListenerSet getListenerSet() {
        return this.listeners;
    }
}

