/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.application.SimulatorPlugin;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.TriggerCollection;
import de.renew.engine.searcher.Triggerable;
import de.renew.engine.searcher.UplinkProvider;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.simulator.ExecuteFinder;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.engine.simulator.SimulatorHelper;
import de.renew.net.NetInstance;
import de.renew.net.Transition;
import de.renew.net.TransitionOccurrence;
import de.renew.net.event.FiringEvent;
import de.renew.net.event.TransitionEventListener;
import de.renew.net.event.TransitionEventListenerSet;
import de.renew.net.event.TransitionEventProducer;
import de.renew.unify.Impossible;
import de.renew.unify.Variable;
import de.renew.util.DelayedFieldOwner;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TransitionInstance
implements Searchable,
Triggerable,
UplinkProvider,
TransitionEventProducer,
Serializable,
DelayedFieldOwner {
    static final long serialVersionUID = -2146903280470015837L;
    private NetInstance netInstance;
    private Transition transition;
    private transient TriggerCollection triggers = new TriggerCollection(this);
    private transient Set<FiringEvent> pendingEvents = new HashSet<FiringEvent>();
    private transient TransitionEventListenerSet listeners = new TransitionEventListenerSet();
    private transient Runnable executeAfterDeserialization = null;

    TransitionInstance(NetInstance netInstance, Transition transition) {
        this.netInstance = netInstance;
        this.transition = transition;
    }

    public String toString() {
        return this.netInstance.toString() + "." + this.transition.toString();
    }

    public NetInstance getNetInstance() {
        return this.netInstance;
    }

    public Transition getTransition() {
        return this.transition;
    }

    @Override
    public TriggerCollection triggers() {
        return this.triggers;
    }

    @Override
    public void addTransitionEventListener(TransitionEventListener transitionEventListener) {
        this.listeners.addTransitionEventListener(transitionEventListener);
    }

    @Override
    public void removeTransitionEventListener(TransitionEventListener transitionEventListener) {
        this.listeners.removeTransitionEventListener(transitionEventListener);
    }

    @Override
    public void proposeSearch() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (this.transition.isSpontaneous()) {
            SearchQueue.includeNow(this);
        }
    }

    synchronized void firingStarted(FiringEvent firingEvent) {
        this.pendingEvents.add(firingEvent);
        this.listeners.firingStarted(firingEvent);
        this.transition.getListenerSet().firingStarted(firingEvent);
    }

    synchronized void firingComplete(FiringEvent firingEvent) {
        this.pendingEvents.remove(firingEvent);
        this.listeners.firingComplete(firingEvent);
        this.transition.getListenerSet().firingComplete(firingEvent);
    }

    public Iterator<FiringEvent> pendingFiringEvents() {
        return this.pendingEvents.iterator();
    }

    public synchronized boolean isFiring() {
        return !this.pendingEvents.isEmpty();
    }

    void createConfirmation() {
        if (this.transition.isSpontaneous()) {
            SearchQueue.includeNow(this);
        }
    }

    public boolean listensToChannel(String string) {
        return this.transition.listensToChannel(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndSearchOccurrence(Variable variable, Searcher searcher) {
        int n = searcher.recorder.checkpoint();
        try {
            searcher.search(new TransitionOccurrence(this, variable, searcher));
        }
        catch (Impossible impossible) {
        }
        finally {
            searcher.recorder.restore(n);
        }
    }

    @Override
    public void bindChannel(Variable variable, Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.createAndSearchOccurrence(variable, searcher);
    }

    @Override
    public void startSearch(Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.createAndSearchOccurrence(null, searcher);
        searcher.recorder.restore();
    }

    public boolean fireOneBinding(boolean bl, Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        ExecuteFinder executeFinder = new ExecuteFinder();
        SimulatorHelper.searchOnce(searcher, executeFinder, this, this);
        StepIdentifier stepIdentifier = SimulatorPlugin.getCurrent().getCurrentEnvironment().getSimulator().nextStepIdentifier();
        if (executeFinder.isCompleted()) {
            executeFinder.execute(stepIdentifier, bl);
            return true;
        }
        return false;
    }

    public boolean fireOneBinding(boolean bl) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        Searcher searcher = new Searcher();
        return this.fireOneBinding(bl, searcher);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RenewObjectOutputStream renewObjectOutputStream = null;
        if (objectOutputStream instanceof RenewObjectOutputStream) {
            renewObjectOutputStream = (RenewObjectOutputStream)objectOutputStream;
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.beginDomain((Object)this);
        }
        if (this.pendingEvents.isEmpty()) {
            objectOutputStream.defaultWriteObject();
            if (renewObjectOutputStream != null) {
                renewObjectOutputStream.delayedWriteObject((Object)this.triggers, (DelayedFieldOwner)this);
            } else {
                objectOutputStream.writeObject(this.triggers);
            }
        } else {
            throw new NotSerializableException("Active bindings  at transition instance " + this);
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.endDomain((Object)this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        objectInputStream.defaultReadObject();
        this.pendingEvents = new HashSet<FiringEvent>();
        this.listeners = new TransitionEventListenerSet();
        if (objectInputStream instanceof RenewObjectInputStream) {
            RenewObjectInputStream renewObjectInputStream = (RenewObjectInputStream)objectInputStream;
            if (renewObjectInputStream.isCopiousBehaviour()) {
                final TransitionInstance transitionInstance = this;
                this.executeAfterDeserialization = new Runnable(){

                    @Override
                    public void run() {
                        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
                        if (TransitionInstance.this.transition.isSpontaneous()) {
                            SearchQueue.includeNow(transitionInstance);
                        }
                    }
                };
            }
        } else {
            this.triggers = (TriggerCollection)objectInputStream.readObject();
        }
    }

    public void reassignField(Object object) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (object instanceof TriggerCollection) {
            this.triggers = (TriggerCollection)object;
            if (this.executeAfterDeserialization != null) {
                this.executeAfterDeserialization.run();
                this.executeAfterDeserialization = null;
            }
        } else {
            throw new NotSerializableException("Value of unexpected type given to reassign().");
        }
    }
}

