/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.arc;

import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.events.Clearing;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.searcher.EarlyExecutable;
import de.renew.net.PlaceInstance;
import de.renew.net.TransitionInstance;
import de.renew.net.arc.ClearArc;
import de.renew.unify.Impossible;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.Value;
import java.lang.reflect.Array;
import java.util.Vector;

class ClearArcExecutable
implements EarlyExecutable {
    PlaceInstance pInstance;
    TransitionInstance tInstance;
    Variable variable;
    ClearArc arc;
    Vector<Object> removedTokens;
    Vector<Double> removedTimeStamps;

    ClearArcExecutable(PlaceInstance placeInstance, TransitionInstance transitionInstance, Variable variable, ClearArc clearArc) {
        this.pInstance = placeInstance;
        this.tInstance = transitionInstance;
        this.variable = variable;
        this.arc = clearArc;
    }

    public long lockPriority() {
        return this.pInstance.lockOrder;
    }

    @Override
    public int phase() {
        return -1;
    }

    public void lock() {
        this.pInstance.lock.lock();
    }

    @Override
    public void verify(StepIdentifier stepIdentifier) throws Impossible {
        this.removedTokens = new Vector(8, 0);
        this.removedTimeStamps = new Vector(8, 0);
        this.pInstance.extractAllTokens(this.removedTokens, this.removedTimeStamps);
        Object object = Array.newInstance(this.arc.elementType, this.removedTokens.size());
        for (int i = 0; i < this.removedTokens.size(); ++i) {
            Object object2 = this.removedTokens.elementAt(i);
            if (this.arc.elementType.isPrimitive()) {
                object2 = Value.unvalueAndCast((Object)object2, this.arc.elementType);
            }
            Array.set(object, i, object2);
        }
        Unify.unify(this.variable, object, null);
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        if (this.arc.getTrace()) {
            SimulatorEventLogger.log(stepIdentifier, (SimulationEvent)new Clearing(this.pInstance), this.pInstance);
        }
    }

    @Override
    public void rollback() {
        for (int i = 0; i < this.removedTokens.size(); ++i) {
            Object object = this.removedTokens.elementAt(i);
            double d = this.removedTimeStamps.elementAt(i);
            this.pInstance.internallyInsertToken(object, d, false);
        }
        this.removedTokens = null;
    }

    public void unlock() {
        this.pInstance.lock.unlock();
    }
}

