/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.arc;

import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.events.Putting;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.searcher.LateExecutable;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.net.PlaceInstance;
import de.renew.net.TransitionInstance;
import de.renew.net.arc.FlexibleArc;
import de.renew.unify.Impossible;
import de.renew.unify.List;
import de.renew.unify.Variable;
import de.renew.util.Value;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;

class FlexibleOutArcExecutable
implements LateExecutable {
    PlaceInstance pInstance;
    TransitionInstance tInstance;
    Variable tokenVar;
    FlexibleArc arc;

    FlexibleOutArcExecutable(PlaceInstance placeInstance, TransitionInstance transitionInstance, Variable variable, FlexibleArc flexibleArc) {
        this.pInstance = placeInstance;
        this.tInstance = transitionInstance;
        this.tokenVar = variable;
        this.arc = flexibleArc;
    }

    @Override
    public int phase() {
        return 3;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    private void putSingleToken(StepIdentifier stepIdentifier, Object object) {
        if (this.arc.forwardFunction != null) {
            try {
                object = this.arc.forwardFunction.function(object);
            }
            catch (Impossible impossible) {
                // empty catch block
            }
        }
        if (this.arc.getTrace()) {
            SimulatorEventLogger.log(stepIdentifier, (SimulationEvent)new Putting(object, this.pInstance), this.pInstance);
        }
        this.pInstance.insertToken(object, SearchQueue.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(StepIdentifier stepIdentifier) {
        block17: {
            Object object = this.tokenVar.getValue();
            this.pInstance.lock.lock();
            try {
                if (object == null) {
                    break block17;
                }
                if (object instanceof Iterator) {
                    Iterator iterator = (Iterator)object;
                    while (iterator.hasNext()) {
                        this.putSingleToken(stepIdentifier, iterator.next());
                    }
                    break block17;
                }
                if (object instanceof Enumeration) {
                    Enumeration enumeration = (Enumeration)object;
                    while (enumeration.hasMoreElements()) {
                        this.putSingleToken(stepIdentifier, enumeration.nextElement());
                    }
                    break block17;
                }
                if (object.getClass().isArray()) {
                    int n = Array.getLength(object);
                    Class<?> clazz = object.getClass().getComponentType();
                    for (int i = 0; i < n; ++i) {
                        Object object2 = Array.get(object, i);
                        if (clazz.isPrimitive()) {
                            object2 = new Value(object2);
                        }
                        this.putSingleToken(stepIdentifier, object2);
                    }
                    break block17;
                }
                if (object instanceof List) {
                    List list = (List)object;
                    while (!list.isNull()) {
                        this.putSingleToken(stepIdentifier, list.head());
                        if (!(list.tail() instanceof List)) {
                            break block17;
                        }
                        list = (List)list.tail();
                    }
                    break block17;
                }
                if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        this.putSingleToken(stepIdentifier, iterator.next());
                    }
                } else {
                    this.putSingleToken(stepIdentifier, object);
                }
            }
            finally {
                this.pInstance.lock.unlock();
            }
        }
    }

    @Override
    public void executeAfterException(StepIdentifier stepIdentifier, Throwable throwable) {
    }
}

