/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.event;

import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.engine.simulator.SimulatorEventQueue;
import de.renew.net.event.ListenerSetDispatcher;
import de.renew.net.event.NetEventListener;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ListenerSet {
    public static final Logger logger = Logger.getLogger(ListenerSet.class);
    private transient Set<NetEventListener> listeners = new HashSet<NetEventListener>();

    synchronized void include(NetEventListener netEventListener) {
        this.listeners.add(netEventListener);
    }

    synchronized void exclude(NetEventListener netEventListener) {
        this.listeners.remove(netEventListener);
    }

    synchronized void dispatch(final ListenerSetDispatcher listenerSetDispatcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        NetEventListener[] netEventListenerArray = this.listeners.toArray(new NetEventListener[0]);
        for (int i = 0; i < netEventListenerArray.length; ++i) {
            if (netEventListenerArray[i].wantSynchronousNotification()) {
                try {
                    listenerSetDispatcher.dispatchTo(netEventListenerArray[i]);
                }
                catch (RuntimeException runtimeException) {
                    logger.error((Object)("Error while dispatching net event: " + runtimeException), (Throwable)runtimeException);
                }
                catch (Error error) {
                    logger.error((Object)("Error while dispatching net event: " + error), (Throwable)error);
                }
                continue;
            }
            final NetEventListener netEventListener = netEventListenerArray[i];
            SimulatorEventQueue.enqueue(new Runnable(){

                @Override
                public void run() {
                    assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
                    try {
                        listenerSetDispatcher.dispatchTo(netEventListener);
                    }
                    catch (RuntimeException runtimeException) {
                        logger.error((Object)("Error while dispatching net event: " + runtimeException), (Throwable)runtimeException);
                    }
                    catch (Error error) {
                        logger.error((Object)("Error while dispatching net event: " + error), (Throwable)error);
                    }
                }
            });
        }
    }
}

