/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadow;

import de.renew.net.NetNotFoundException;
import de.renew.net.loading.Finder;
import de.renew.net.loading.PathlessFinder;
import de.renew.shadow.SNSFinder;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetLoader;
import de.renew.shadow.ShadowNetSystem;
import de.renew.util.StringUtil;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class DefaultShadowNetLoader
implements ShadowNetLoader {
    public static Logger logger = Logger.getLogger(DefaultShadowNetLoader.class);
    private Set<Finder> finders = new LinkedHashSet<Finder>();
    private Set<PathlessFinder> pathlessFinders = new LinkedHashSet<PathlessFinder>();
    private PathEntry[] netSource;

    public DefaultShadowNetLoader(Properties properties) {
        this.registerFinder(new SNSFinder());
        if (properties != null) {
            this.configureNetPath(properties);
        } else {
            this.configureNetPath(System.getProperties());
        }
    }

    public void configureNetPath(Properties properties) {
        this.setNetPath(properties.getProperty("de.renew.netPath", System.getProperty("user.dir")));
    }

    void setNetPath(String string) {
        this.setNetPath(StringUtil.splitPaths((String)string));
    }

    void setNetPath(String[] stringArray) {
        this.netSource = DefaultShadowNetLoader.canonizePaths(stringArray);
        for (int i = 0; i < this.netSource.length; ++i) {
            logger.debug((Object)("Shadow net loader source" + (this.netSource[i].isClasspathRelative ? " (relative to CLASSPATH): " : ": ") + this.netSource[i].path));
        }
    }

    public static PathEntry[] canonizePaths(String[] stringArray) {
        if (stringArray == null) {
            return new PathEntry[0];
        }
        PathEntry[] pathEntryArray = new PathEntry[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            pathEntryArray[i] = stringArray[i].trim().startsWith("CLASSPATH" + File.separator) ? new PathEntry(stringArray[i].trim().substring(9 + File.separator.length()), true) : (stringArray[i].trim().equals("CLASSPATH") ? new PathEntry("", true) : new PathEntry(StringUtil.makeCanonical((String)stringArray[i]), false));
        }
        return pathEntryArray;
    }

    public static String asPathString(PathEntry[] pathEntryArray) {
        if (pathEntryArray == null || pathEntryArray.length == 0) {
            return "";
        }
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < pathEntryArray.length; ++i) {
            if (pathEntryArray[i] == null) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(File.pathSeparator);
            }
            if (pathEntryArray[i].isClasspathRelative) {
                stringBuffer.append("CLASSPATH");
                if (!"".equals(pathEntryArray[i].path)) {
                    stringBuffer.append(File.separator);
                }
            }
            stringBuffer.append(pathEntryArray[i].path);
        }
        return stringBuffer.toString();
    }

    @Override
    public ShadowNetSystem loadShadowNetSystem(String string) throws NetNotFoundException {
        ShadowNetSystem shadowNetSystem = this.findShadowNetSystemFile(string);
        if (shadowNetSystem != null) {
            return shadowNetSystem;
        }
        throw new NetNotFoundException(string);
    }

    @Override
    public ShadowNet loadShadowNet(String string, ShadowNetSystem shadowNetSystem) throws NetNotFoundException {
        ShadowNetSystem shadowNetSystem2 = this.loadShadowNetSystem(string);
        ShadowNet shadowNet = shadowNetSystem2.elements().iterator().next();
        if (shadowNet != null && string.equals(shadowNet.getName())) {
            shadowNet.switchNetSystem(shadowNetSystem);
            return shadowNet;
        }
        throw new NetNotFoundException(string);
    }

    public ShadowNetSystem findShadowNetSystemFile(String string) {
        ShadowNetSystem shadowNetSystem = null;
        for (PathlessFinder object : this.pathlessFinders) {
            logger.debug((Object)("Searching for net " + string + " in pathless finder " + object));
            shadowNetSystem = object.findNetFile(string);
            if (shadowNetSystem == null || shadowNetSystem.elements().isEmpty()) continue;
            return shadowNetSystem;
        }
        for (int i = 0; i < this.netSource.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.netSource[i].path);
            if (!"".equals(this.netSource[i].path)) {
                stringBuffer.append(File.separator);
            }
            stringBuffer.append(string);
            for (Finder finder : this.finders) {
                logger.debug((Object)("Searching for net " + stringBuffer + " in finder " + finder));
                shadowNetSystem = this.netSource[i].isClasspathRelative ? finder.findNetClasspathRel(string, stringBuffer) : finder.findNetFile(string, stringBuffer);
                if (shadowNetSystem == null || shadowNetSystem.elements().isEmpty()) continue;
                return shadowNetSystem;
            }
        }
        return null;
    }

    public boolean registerFinder(Finder finder) {
        return this.finders.add(finder);
    }

    public boolean removeFinder(Finder finder) {
        return this.finders.remove(finder);
    }

    public boolean registerPathlessFinder(PathlessFinder pathlessFinder) {
        return this.pathlessFinders.add(pathlessFinder);
    }

    public boolean removePathlessFinder(PathlessFinder pathlessFinder) {
        return this.pathlessFinders.remove(pathlessFinder);
    }

    public static class PathEntry {
        public final String path;
        public final boolean isClasspathRelative;

        public PathEntry(String string, boolean bl) {
            this.path = string;
            this.isClasspathRelative = bl;
        }
    }
}

