/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadow;

import de.renew.shadow.ShadowCompiler;
import de.renew.shadow.ShadowCompilerFactory;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowNetElement;
import de.renew.shadow.ShadowNetSystem;
import de.renew.shadow.SyntaxException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ShadowNet
implements Serializable {
    static final long serialVersionUID = 5180248532101141649L;
    public transient Object context = null;
    private Set<ShadowNetElement> elements = new HashSet<ShadowNetElement>();
    private String name;
    private ShadowCompilerFactory compilerFactory;
    private ShadowNetSystem netSystem;

    public ShadowNet(String string, ShadowNetSystem shadowNetSystem) {
        this.name = string;
        this.netSystem = shadowNetSystem;
        shadowNetSystem.add(this);
    }

    public ShadowCompilerFactory getCompilerFactory() {
        return this.compilerFactory;
    }

    public void setCompilerFactory(ShadowCompilerFactory shadowCompilerFactory) {
        this.compilerFactory = shadowCompilerFactory;
    }

    private ShadowCompiler createShadowNetCompiler() throws SyntaxException {
        if (this.compilerFactory != null) {
            return this.compilerFactory.createCompiler();
        }
        if (this.netSystem.getDefaultCompilerFactory() != null) {
            return this.netSystem.getDefaultCompilerFactory().createCompiler();
        }
        throw new SyntaxException("No compiler or default compiler set for net " + this.getName(), new String[0]);
    }

    ShadowCompiler createInititalizedShadowNetCompiler(ShadowLookup shadowLookup) throws SyntaxException {
        ShadowCompiler shadowCompiler = this.createShadowNetCompiler();
        shadowCompiler.setLoopbackNetLoader(this.netSystem.createNetLoader(shadowLookup));
        shadowCompiler.setShadowLookup(shadowLookup);
        return shadowCompiler;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public Set<ShadowNetElement> elements() {
        return Collections.unmodifiableSet(this.elements);
    }

    public void discard() {
        this.netSystem.remove(this);
    }

    public void switchNetSystem(ShadowNetSystem shadowNetSystem) {
        ShadowCompilerFactory shadowCompilerFactory = this.getCompilerFactory();
        if (shadowCompilerFactory == null && (shadowCompilerFactory = this.netSystem.getDefaultCompilerFactory()) != null && !shadowCompilerFactory.equals(shadowNetSystem.getDefaultCompilerFactory())) {
            this.setCompilerFactory(shadowCompilerFactory);
        }
        this.netSystem.remove(this);
        this.netSystem = shadowNetSystem;
        this.netSystem.add(this);
        if (shadowCompilerFactory != null && shadowCompilerFactory.equals(this.netSystem.getDefaultCompilerFactory())) {
            this.setCompilerFactory(null);
        }
    }

    void add(ShadowNetElement shadowNetElement) {
        this.elements.add(shadowNetElement);
    }

    void remove(ShadowNetElement shadowNetElement) {
        this.elements.remove(shadowNetElement);
        shadowNetElement.context = null;
    }

    public String toString() {
        return "ShadowNet \"" + this.name + "\" (" + this.elements.size() + " elements)";
    }

    public String checkDeclarationNode(String string, boolean bl) throws SyntaxException {
        return this.createInititalizedShadowNetCompiler(new ShadowLookup()).checkDeclarationNode(string, bl, this);
    }

    public String checkTransitionInscription(String string, boolean bl) throws SyntaxException {
        return this.createInititalizedShadowNetCompiler(new ShadowLookup()).checkTransitionInscription(string, bl, this);
    }

    public String checkPlaceInscription(String string, boolean bl) throws SyntaxException {
        return this.createInititalizedShadowNetCompiler(new ShadowLookup()).checkPlaceInscription(string, bl, this);
    }

    public String checkArcInscription(String string, boolean bl) throws SyntaxException {
        return this.createInititalizedShadowNetCompiler(new ShadowLookup()).checkArcInscription(string, bl, this);
    }
}

