/*
 * Decompiled with CFR 0.152.
 */
package de.renew.appleui;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEventListener;
import com.apple.eawt.Application;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.QuitHandler;
import de.renew.appleui.AboutDisplayer;
import de.renew.appleui.AppleUIListener;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.SoftDependency;

public class AppleUI
extends PluginAdapter {
    private Application app = null;
    private AppleUIListener listener = null;
    private SoftDependency guiDependency;

    public AppleUI(PluginProperties pluginProperties) {
        super(pluginProperties);
        String string = pluginProperties.getProperty("com.apple.macos.useScreenMenubar", "true");
        String string2 = pluginProperties.getProperty("com.apple.mrj.application.apple.menu.about.name", "Renew");
        System.setProperty("com.apple.macos.useScreenMenubar", string);
        System.setProperty("apple.laf.useScreenMenuBar", string);
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", string2);
    }

    public void init() {
        this.app = Application.getApplication();
        this.listener = new AppleUIListener();
        this.setAboutDisplayer(null);
        this.app.setAboutHandler((AboutHandler)this.listener);
        this.app.addAppEventListener((AppEventListener)this.listener);
        this.app.setQuitHandler((QuitHandler)this.listener);
        this.app.setOpenFileHandler((OpenFilesHandler)this.listener);
        this.guiDependency = new SoftDependency((IPlugin)this, "de.renew.gui", "de.renew.appleui.GuiDependencyListener");
    }

    public boolean cleanup() {
        if (this.app != null) {
            this.app.removeAppEventListener((AppEventListener)this.listener);
            this.app = null;
            this.listener = null;
        }
        if (this.guiDependency != null) {
            this.guiDependency.discard();
            this.guiDependency = null;
        }
        return true;
    }

    void setAboutDisplayer(AboutDisplayer aboutDisplayer) {
        if (this.app != null && this.listener != null) {
            this.listener.setAboutDisplayer(aboutDisplayer);
        }
    }
}

