/*
 * Decompiled with CFR 0.152.
 */
package de.renew.appleui;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.AppReOpenedListener;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.PrintFilesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import de.renew.appleui.AboutDisplayer;
import de.renew.plugin.PluginManager;
import de.renew.plugin.command.CLCommand;
import java.io.File;
import java.util.List;

class AppleUIListener
implements AboutHandler,
PreferencesHandler,
AppReOpenedListener,
OpenFilesHandler,
PrintFilesHandler,
QuitHandler {
    private AboutDisplayer displayer = null;

    AppleUIListener() {
    }

    void setAboutDisplayer(AboutDisplayer aboutDisplayer) {
        this.displayer = aboutDisplayer;
    }

    public void handleQuitRequestWith(AppEvent.QuitEvent quitEvent, QuitResponse quitResponse) {
        PluginManager.getInstance().stop();
    }

    public void printFiles(AppEvent.PrintFilesEvent printFilesEvent) {
    }

    public void openFiles(AppEvent.OpenFilesEvent openFilesEvent) {
        CLCommand cLCommand = (CLCommand)PluginManager.getInstance().getCLCommands().get("gui");
        if (cLCommand != null) {
            List list = openFilesEvent.getFiles();
            String[] stringArray = new String[list.size()];
            int n = 0;
            for (File file : list) {
                stringArray[n++] = file.getPath();
            }
            cLCommand.execute(stringArray, System.out);
        }
    }

    public void appReOpened(AppEvent.AppReOpenedEvent appReOpenedEvent) {
        this.displayer.bringMenuFrameToFront();
    }

    public void handlePreferences(AppEvent.PreferencesEvent preferencesEvent) {
    }

    public void handleAbout(AppEvent.AboutEvent aboutEvent) {
        this.displayer.displayAboutBox();
    }
}

