/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.logging;

import de.renew.gui.logging.AppenderFactory;
import de.renew.gui.logging.ConfigureLoggingController;
import de.renew.gui.logging.TreeNodeAppenderWrapper;
import de.renew.gui.logging.TreeNodeLoggerWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class ConfigureLoggingTab
extends JPanel {
    private ConfigureLoggingController controller;
    private JTree loggerTree;
    private JScrollPane infoPane;
    private JSplitPane splitPane;

    public ConfigureLoggingTab(ConfigureLoggingController configureLoggingController) {
        super(new BorderLayout());
        this.controller = configureLoggingController;
        this.initComponents();
    }

    private void initComponents() {
        this.setName("Logging");
        this.loggerTree = new JTree();
        this.loggerTree.addMouseListener(new PopupMenuMouseListener());
        TreeSelectionModel treeSelectionModel = this.loggerTree.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        this.loggerTree.addTreeSelectionListener(this.controller);
        JScrollPane jScrollPane = new JScrollPane(this.loggerTree);
        jScrollPane.setMinimumSize(new Dimension(300, 200));
        this.splitPane = new JSplitPane(1, jScrollPane, this.infoPane);
        this.add((Component)this.splitPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.add((Component)new JLabel("Select an appender to display and edit attributes."), "North");
        jPanel.setPreferredSize(new Dimension(300, 200));
        this.setRightSide(jPanel);
    }

    protected void setRootNode(MutableTreeNode mutableTreeNode) {
        this.loggerTree.setModel(new DefaultTreeModel(mutableTreeNode));
    }

    protected void setRightSide(JComponent jComponent) {
        this.splitPane.setRightComponent(jComponent);
        this.splitPane.resetToPreferredSizes();
    }

    private class PopupMenuMouseListener
    extends MouseAdapter {
        private PopupMenuMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof JTree && mouseEvent.isPopupTrigger()) {
                this.openPopup((JTree)component, mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof JTree && mouseEvent.isPopupTrigger()) {
                this.openPopup((JTree)component, mouseEvent);
            }
        }

        private void openPopup(JTree jTree, MouseEvent mouseEvent) {
            Object object;
            Point point = mouseEvent.getPoint();
            TreePath treePath = jTree.getPathForLocation(point.x, point.y);
            if (treePath == null) {
                return;
            }
            Object object2 = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("add logger");
            jMenuItem.addActionListener(ConfigureLoggingTab.this.controller.createAddLoggerAction());
            jMenuItem.setEnabled(false);
            jPopupMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("remove logger");
            jMenuItem2.setEnabled(false);
            jPopupMenu.add(jMenuItem2);
            jPopupMenu.addSeparator();
            JMenu jMenu = new JMenu("add appender");
            jMenu.setEnabled(false);
            jPopupMenu.add(jMenu);
            JMenuItem jMenuItem3 = new JMenuItem("remove appender");
            jMenuItem3.setEnabled(false);
            jPopupMenu.add(jMenuItem3);
            if (object2 instanceof TreeNodeLoggerWrapper) {
                object = (TreeNodeLoggerWrapper)object2;
                jMenuItem2.setEnabled(true);
                jMenuItem2.addActionListener(ConfigureLoggingTab.this.controller.createRemoveLoggerAction(((TreeNodeLoggerWrapper)object).getLogger().getName()));
                String[] stringArray = AppenderFactory.getInstance().getAllAppenderTypes();
                for (int i = 0; i < stringArray.length; ++i) {
                    JMenuItem jMenuItem4 = new JMenuItem(stringArray[i]);
                    jMenuItem4.addActionListener(ConfigureLoggingTab.this.controller.createAddAppenderAction(((TreeNodeLoggerWrapper)object).getLogger().getName(), stringArray[i]));
                    jMenu.add(jMenuItem4);
                }
                jMenu.setEnabled(true);
            }
            if (object2 instanceof TreeNodeAppenderWrapper) {
                object = (TreeNodeAppenderWrapper)object2;
                jMenu.setEnabled(true);
                jMenuItem3.addActionListener(ConfigureLoggingTab.this.controller.createRemoveAppenderAction(((TreeNodeAppenderWrapper)object).getLogger().getName(), ((TreeNodeAppenderWrapper)object).getAppender()));
                jMenuItem3.setEnabled(true);
            } else if (object2 instanceof String) {
                jMenuItem.setEnabled(true);
            }
            jPopupMenu.show(jTree, mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

