/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.logging;

import de.renew.engine.common.SimulatorEvent;
import de.renew.gui.logging.LoggerRepository;
import de.renew.gui.logging.MainRepository;
import de.renew.gui.logging.MainRepositoryManager;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class GuiAppender
implements Appender {
    private static Logger logger = Logger.getLogger(GuiAppender.class);
    private List<Filter> filters = new Vector<Filter>();
    private String name = null;
    private int stepPufferSize = 20;

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public Filter getFilter() {
        if (this.filters.isEmpty()) {
            return null;
        }
        return this.filters.get(0);
    }

    public void clearFilters() {
        this.filters.clear();
    }

    public String getName() {
        return this.name;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setLayout(Layout layout) {
    }

    public Layout getLayout() {
        return null;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean requiresLayout() {
        return false;
    }

    public void close() {
    }

    public int getPufferSize() {
        return this.stepPufferSize;
    }

    public void setPufferSize(int n) {
        this.stepPufferSize = n;
    }

    public void doAppend(LoggingEvent loggingEvent) {
        SimulatorEvent simulatorEvent = (SimulatorEvent)loggingEvent.getMessage();
        MainRepository mainRepository = MainRepositoryManager.getInstance().getRepository(simulatorEvent);
        if (mainRepository == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this + ": Discarding event because no matching repository exists: " + simulatorEvent));
            }
            return;
        }
        String[] stringArray = GuiAppender.getDefinedLoggers(loggingEvent.getLoggerName());
        for (int i = 0; i < stringArray.length; ++i) {
            LoggerRepository loggerRepository = mainRepository.getLoggerRepository(stringArray[i], this.stepPufferSize);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(this + ": Dispatching event to " + loggerRepository + ": " + simulatorEvent));
            }
            loggerRepository.addEvent(simulatorEvent);
        }
    }

    private static String[] getDefinedLoggers(String string) {
        Vector<String> vector = new Vector<String>();
        for (Logger logger = Logger.getLogger((String)string); logger != null; logger = logger.getParent()) {
            Enumeration enumeration = logger.getAllAppenders();
            boolean bl = false;
            while (enumeration.hasMoreElements() && !bl) {
                Appender appender = (Appender)enumeration.nextElement();
                if (!(appender instanceof GuiAppender)) continue;
                bl = true;
                vector.add(logger.getName());
            }
        }
        return vector.toArray(new String[0]);
    }
}

