/*
 * Decompiled with CFR 0.152.
 */
package de.renew.application;

import de.renew.application.SimulationEnvironment;
import de.renew.application.SimulationRunningException;
import de.renew.application.SimulatorPlugin;
import de.renew.database.SetupHelper;
import de.renew.database.TransactionSource;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.plugin.command.CLCommand;
import de.renew.shadow.ShadowNetSystem;
import de.renew.util.ParameteredCommandLine;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.StreamCorruptedException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class StartSimulationCommand
implements CLCommand {
    public static Logger logger = Logger.getLogger(StartSimulationCommand.class);
    private SimulatorPlugin plugin;

    public StartSimulationCommand(SimulatorPlugin simulatorPlugin) {
        if (simulatorPlugin == null) {
            throw new NullPointerException("Need SimulatorPlugin reference.");
        }
        this.plugin = simulatorPlugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String[] stringArray, final PrintStream printStream) {
        final ParameteredCommandLine parameteredCommandLine = new ParameteredCommandLine(stringArray, new String[]{"-h", "-i"}, new int[]{0, 0});
        final String[] stringArray2 = parameteredCommandLine.getRemainingArgs();
        if (stringArray2.length != 2 || parameteredCommandLine.hasParameter("-h")) {
            this.showSyntax(printStream);
        } else {
            SimulatorPlugin.lock.lock();
            try {
                Future<Object> future = SimulationThreadPool.getNew().submitAndWait(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object object;
                        ShadowNetSystem shadowNetSystem;
                        String string = stringArray2[0];
                        String string2 = stringArray2[1];
                        FileInputStream fileInputStream = new FileInputStream(string);
                        ObjectInputStream objectInputStream = null;
                        try {
                            objectInputStream = new ObjectInputStream(fileInputStream);
                            shadowNetSystem = (ShadowNetSystem)objectInputStream.readObject();
                        }
                        catch (StreamCorruptedException streamCorruptedException) {
                            throw new IllegalArgumentException("Invalid shadow net system (in file " + string + "): " + streamCorruptedException);
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("Invalid shadow net system (in file " + string + "): " + classCastException);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new IllegalArgumentException("Invalid shadow net system (in file " + string + "): " + classNotFoundException);
                        }
                        finally {
                            block20: {
                                try {
                                    if (fileInputStream != null) {
                                        fileInputStream.close();
                                    }
                                    if (objectInputStream != null) {
                                        objectInputStream.close();
                                    }
                                }
                                catch (Exception exception) {
                                    logger.error((Object)(StartSimulationCommand.class.getSimpleName() + ": " + exception.getMessage()));
                                    if (!logger.isDebugEnabled()) break block20;
                                    logger.debug((Object)(StartSimulationCommand.class.getSimpleName() + ": "), (Throwable)exception);
                                }
                            }
                        }
                        StartSimulationCommand.this.plugin.setupSimulation(null);
                        StartSimulationCommand.this.plugin.insertNets(shadowNetSystem);
                        SetupHelper.SimulationState simulationState = StartSimulationCommand.this.plugin.restoreStateFromDatabase();
                        if (!simulationState.wasSimulationInited()) {
                            object = StartSimulationCommand.this.plugin.createNetInstance(string2);
                            printStream.println("Simulation set up, created net instance " + object + ".");
                        } else {
                            printStream.println("Simulation set up, restored state from database.");
                        }
                        if (!parameteredCommandLine.hasParameter("-i")) {
                            object = StartSimulationCommand.this.plugin.getCurrentEnvironment();
                            ((SimulationEnvironment)object).getSimulator().startRun();
                            printStream.println("Simulation running.");
                        } else {
                            try {
                                TransactionSource.simulationStateChanged(true, false);
                            }
                            catch (Exception exception) {
                                logger.error((Object)exception.getMessage(), (Throwable)exception);
                            }
                        }
                        return null;
                    }
                });
                future.get();
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (throwable instanceof SimulationRunningException) {
                    printStream.println("Simulation already running");
                } else {
                    logger.debug((Object)throwable.toString(), (Throwable)executionException);
                    printStream.println(throwable.toString());
                    printStream.println("Cleaning up.");
                    this.plugin.terminateSimulation();
                }
            }
            catch (SimulationRunningException simulationRunningException) {
                printStream.println("Simulation already running");
            }
            catch (Exception exception) {
                logger.debug((Object)exception.toString(), (Throwable)exception);
                printStream.println(exception.toString());
                printStream.println("Cleaning up.");
                this.plugin.terminateSimulation();
            }
            finally {
                SimulatorPlugin.lock.unlock();
            }
        }
    }

    public String getDescription() {
        return "set up a simulation with given nets (-h for help).";
    }

    public void showSyntax(PrintStream printStream) {
        printStream.println("Parameters: <net system> <primary net> [-i]");
        printStream.println("  <net system>  : The file name of the exported shadow net system to load.");
        printStream.println("  <primary net> : The name of the primary net to create an instance of.");
        printStream.println("  -i            : Initialize the simulation only, don't run it.");
        printStream.println("To configure the simulation engine and installed extensions, use the");
        printStream.println("available plugin properties before starting the simulation (e.g. ");
        printStream.println("de.renew.simulatorMode or de.renew.eagerSimulation).");
    }
}

