/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database;

import de.renew.database.IllegalTokenException;
import de.renew.database.NetInstanceMap;
import de.renew.database.NetInstanceResolutionInputStream;
import de.renew.database.RestoreSource;
import de.renew.database.entitylayer.Entity;
import de.renew.database.entitylayer.NetInstanceEntity;
import de.renew.database.entitylayer.NoSuchEntityException;
import de.renew.database.entitylayer.SQLDialect;
import de.renew.database.entitylayer.StateEntity;
import de.renew.database.entitylayer.TokenEntity;
import de.renew.database.entitylayer.TokenPositionEntity;
import de.renew.net.PlaceInstance;
import de.renew.util.Base64Coder;
import de.renew.util.ClassSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DatabaseRestoreSource
implements RestoreSource {
    private Connection connection = null;
    private SQLDialect dialect = null;

    public DatabaseRestoreSource(Connection connection, SQLDialect sQLDialect) {
        this.connection = connection;
        this.dialect = sQLDialect;
    }

    protected void finalize() throws SQLException {
        if (this.connection != null) {
            this.connection.rollback();
            this.connection.close();
            this.connection = null;
        }
    }

    @Override
    public void fillinAllTokens(PlaceInstance placeInstance, Vector<String> vector) throws SQLException {
        TokenPositionEntity tokenPositionEntity = new TokenPositionEntity(this.connection, this.dialect);
        Vector<Entity> vector2 = Entity.getEntities(tokenPositionEntity, "NET_INSTANCE_ID='" + placeInstance.getNetInstance().getID() + "'" + " and PLACE_INSTANCE_ID='" + placeInstance.getPlace().getID() + "'");
        Enumeration<Entity> enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            tokenPositionEntity = (TokenPositionEntity)enumeration.nextElement();
            for (int i = tokenPositionEntity.getQuantity().intValue(); i > 0; --i) {
                vector.addElement(String.valueOf(tokenPositionEntity.getTokenId()));
            }
        }
    }

    @Override
    public String[] getAllNetIDs() throws SQLException {
        Vector<Entity> vector = Entity.getEntities(new NetInstanceEntity(this.connection, this.dialect));
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = ((NetInstanceEntity)vector.elementAt(i)).getNetInstanceId().toString();
        }
        return stringArray;
    }

    public int getLastId() throws SQLException {
        int n = 0;
        NetInstanceEntity netInstanceEntity = new NetInstanceEntity(this.connection, this.dialect);
        Vector<Entity> vector = Entity.getEntities(netInstanceEntity, null, "NET_INSTANCE_ID");
        if (vector.size() > 0) {
            try {
                n = ((NetInstanceEntity)vector.lastElement()).getNetInstanceId();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int n2 = 0;
        TokenEntity tokenEntity = new TokenEntity(this.connection, this.dialect);
        vector = Entity.getEntities(tokenEntity, null, "TOKEN_ID");
        if (vector.size() > 0) {
            try {
                n2 = ((TokenEntity)vector.lastElement()).getTokenId();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2 > n ? n2 : n;
    }

    @Override
    public String getNetName(String string) throws SQLException {
        NetInstanceEntity netInstanceEntity = new NetInstanceEntity(this.connection, this.dialect);
        netInstanceEntity.load(string);
        return netInstanceEntity.getName();
    }

    @Override
    public Hashtable<String, Object> getTokens(NetInstanceMap netInstanceMap) throws SQLException, IllegalTokenException {
        TokenEntity tokenEntity = new TokenEntity(this.connection, this.dialect);
        Vector<Entity> vector = Entity.getEntities(tokenEntity);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Enumeration<Entity> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            tokenEntity = (TokenEntity)enumeration.nextElement();
            Class clazz = null;
            ByteArrayInputStream byteArrayInputStream = null;
            ObjectInputStream objectInputStream = null;
            try {
                clazz = ClassSource.classForName((String)tokenEntity.getClassName());
                byteArrayInputStream = new ByteArrayInputStream(Base64Coder.decode((String)tokenEntity.getSerialisation()));
                objectInputStream = new NetInstanceResolutionInputStream(byteArrayInputStream, netInstanceMap);
                Object object = objectInputStream.readObject();
                hashtable.put(String.valueOf(tokenEntity.getTokenId()), object);
            }
            catch (InvalidClassException invalidClassException) {
                throw new IllegalTokenException("The database's token with id " + tokenEntity.getTokenId() + " is invalid.\n" + "Class " + (clazz != null ? clazz.getName() : null) + " is no valid class for deserialisation, because:\n" + invalidClassException.toString());
            }
            catch (StreamCorruptedException streamCorruptedException) {
                throw new IllegalTokenException("The database's token with id " + tokenEntity.getTokenId() + " is invalid.\n" + "It has invalid serialisation data: " + "Control information corrupt.");
            }
            catch (OptionalDataException optionalDataException) {
                throw new IllegalTokenException("The database's token with id " + tokenEntity.getTokenId() + " is invalid.\n" + "It has invalid serialisation data: " + "Serialisation not recognized.");
            }
            catch (NotSerializableException notSerializableException) {
                throw new IllegalTokenException("The database's token with id " + tokenEntity.getTokenId() + " is invalid.\n" + "It has invalid serialisation data or the class " + (clazz != null ? clazz.getName() : null) + " is not serializable.");
            }
            catch (IOException iOException) {
                throw new IllegalTokenException("The database's token with id " + tokenEntity.getTokenId() + " is invalid.\n" + "I/O exception during deserialisation:\n" + iOException.toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalTokenException("The database's token with id " + tokenEntity.getTokenId() + " is invalid.\n" + "Class " + (clazz != null ? clazz.getName() : null) + " cannot be found.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalTokenException("The database's token with id " + tokenEntity.getTokenId() + " is invalid. " + "It has not a valid base 64 coded serialisation.");
            }
            catch (SecurityException securityException) {
                throw new IllegalTokenException("The database's token with id " + tokenEntity.getTokenId() + " is invalid.\n" + "The default constructor of class " + (clazz != null ? clazz.getName() : null) + " is not accessable.");
            }
            finally {
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                    if (byteArrayInputStream == null) continue;
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return hashtable;
    }

    @Override
    public String[] getViewedNetIDs() throws Exception {
        Vector<Entity> vector = Entity.getEntities(new NetInstanceEntity(this.connection, this.dialect), "DRAWING_OPEN=1");
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = ((NetInstanceEntity)vector.elementAt(i)).getNetInstanceId().toString();
        }
        return stringArray;
    }

    @Override
    public boolean wasSimulationInited() throws SQLException {
        StateEntity stateEntity = new StateEntity(this.connection, this.dialect);
        try {
            stateEntity.load(new Object[0]);
        }
        catch (NoSuchEntityException noSuchEntityException) {
            return false;
        }
        return stateEntity.getInited() == 1;
    }

    @Override
    public boolean wasSimulationRunning() throws SQLException {
        StateEntity stateEntity = new StateEntity(this.connection, this.dialect);
        try {
            stateEntity.load(new Object[0]);
        }
        catch (NoSuchEntityException noSuchEntityException) {
            return false;
        }
        return stateEntity.getRunning() == 1;
    }
}

