/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database;

import de.renew.database.IllegalTokenException;
import de.renew.database.NetAction;
import de.renew.database.TokenAction;
import de.renew.database.TransactionStrategy;
import de.renew.database.entitylayer.Entity;
import de.renew.database.entitylayer.NetInstanceEntity;
import de.renew.database.entitylayer.NoSuchEntityException;
import de.renew.database.entitylayer.SQLDialect;
import de.renew.database.entitylayer.StateEntity;
import de.renew.database.entitylayer.TokenEntity;
import de.renew.database.entitylayer.TokenPositionEntity;
import de.renew.util.Base64Coder;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DatabaseTransactionStrategy
implements TransactionStrategy {
    public static Logger logger = Logger.getLogger(DatabaseTransactionStrategy.class);
    private Connection connection = null;
    private SQLDialect dialect = null;

    public DatabaseTransactionStrategy(String string, SQLDialect sQLDialect) throws SQLException {
        this.connection = DriverManager.getConnection(string);
        this.connection.setAutoCommit(false);
        this.dialect = sQLDialect;
    }

    public DatabaseTransactionStrategy(String string, String string2, String string3, SQLDialect sQLDialect) throws SQLException {
        this.connection = DriverManager.getConnection(string, string2, string3);
        this.connection.setAutoCommit(false);
        this.dialect = sQLDialect;
    }

    private void addTokens(TokenAction[] tokenActionArray) throws SQLException, IllegalTokenException {
        for (int i = 0; i < tokenActionArray.length; ++i) {
            TokenAction tokenAction = tokenActionArray[i];
            TokenEntity tokenEntity = new TokenEntity(this.connection, this.dialect);
            try {
                tokenEntity.load(tokenAction.getTokenID());
            }
            catch (NoSuchEntityException noSuchEntityException) {
                Object object = tokenAction.getToken();
                try {
                    tokenEntity.setTokenId(Integer.valueOf(tokenAction.getTokenID()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalTokenException("The token with id " + tokenAction.getTokenID() + ", class " + object.getClass().getName() + " and representation " + object.toString() + " cannot be saved, because the ID is not parsable to an int." + " Currently, only int IDs are supported for tokens.");
                }
                tokenEntity.setClassName(object.getClass().getName());
                byte[] byArray = null;
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    new ObjectOutputStream(byteArrayOutputStream).writeObject(object);
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (Exception exception) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    exception.printStackTrace(new PrintWriter(byteArrayOutputStream));
                    throw new IllegalTokenException("The token with id " + tokenAction.getTokenID() + ", class " + object.getClass().getName() + " and representation " + object.toString() + " couldn't be serialized, because there was an exception during" + " serialisation: " + exception.toString() + "\n" + "Only serializable tokens can be handled" + " by the DatabaseTransactionStrategy.");
                }
                tokenEntity.setSerialisation(new String(Base64Coder.encode((byte[])byArray)));
                tokenEntity.save();
            }
            TokenPositionEntity tokenPositionEntity = new TokenPositionEntity(this.connection, this.dialect);
            try {
                tokenPositionEntity.load(new Object[]{tokenAction.getTokenID(), tokenAction.getNetID(), tokenAction.getPlaceID().toString()});
                tokenPositionEntity.setQuantity(new Integer(tokenPositionEntity.getQuantity() + 1));
            }
            catch (NoSuchEntityException noSuchEntityException) {
                tokenPositionEntity.setTokenId(Integer.valueOf(tokenAction.getTokenID()));
                try {
                    tokenPositionEntity.setNetInstanceId(Integer.valueOf(tokenAction.getNetID()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalTokenException("The net instance ID " + tokenAction.getNetID() + " cannot be saved, because it is not parsable to an int." + " Currently, only int IDs are supported for net instances.");
                }
                tokenPositionEntity.setPlaceInstanceId(tokenAction.getPlaceID().toString());
                tokenPositionEntity.setQuantity(new Integer(1));
            }
            tokenPositionEntity.save();
        }
    }

    private void createNets(NetAction[] netActionArray) throws SQLException {
        for (int i = 0; i < netActionArray.length; ++i) {
            NetAction netAction = netActionArray[i];
            NetInstanceEntity netInstanceEntity = new NetInstanceEntity(this.connection, this.dialect);
            try {
                netInstanceEntity.load(netAction.getNetID());
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)(DatabaseTransactionStrategy.class.getSimpleName() + ": loaded net instance entity with id " + netAction.getNetID()));
                continue;
            }
            catch (NoSuchEntityException noSuchEntityException) {
                try {
                    netInstanceEntity.setNetInstanceId(Integer.valueOf(netAction.getNetID()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RuntimeException("The net instance ID " + netAction.getNetID() + " cannot be saved, because it is not parsable to an int." + " Currently, only int IDs are supported for net instances.");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(DatabaseTransactionStrategy.class.getSimpleName() + ": create net instance entity with name " + netAction.getName()));
                }
                netInstanceEntity.setName(netAction.getName());
                netInstanceEntity.setDrawingOpen(new Integer(0));
                netInstanceEntity.save();
            }
        }
    }

    private void deleteNets(NetAction[] netActionArray) throws SQLException {
        for (int i = 0; i < netActionArray.length; ++i) {
            try {
                NetAction netAction = netActionArray[i];
                NetInstanceEntity netInstanceEntity = new NetInstanceEntity(this.connection, this.dialect);
                netInstanceEntity.load(netAction.getNetID());
                TokenPositionEntity tokenPositionEntity = new TokenPositionEntity(this.connection, this.dialect);
                Vector<Entity> vector = Entity.getEntities(tokenPositionEntity, "NET_INSTANCE_ID='" + netAction.getNetID() + "'");
                Enumeration<Entity> enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    tokenPositionEntity = (TokenPositionEntity)enumeration.nextElement();
                    String string = String.valueOf(tokenPositionEntity.getTokenId());
                    tokenPositionEntity.delete();
                    if (Entity.getEntities(tokenPositionEntity, "TOKEN_ID='" + string + "'").size() > 0) continue;
                    TokenEntity tokenEntity = new TokenEntity(this.connection, this.dialect);
                    tokenEntity.load(string);
                    tokenEntity.delete();
                }
                netInstanceEntity.delete();
                continue;
            }
            catch (NoSuchEntityException noSuchEntityException) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws SQLException {
        if (this.connection != null) {
            this.connection.rollback();
            this.connection.close();
            this.connection = null;
        }
    }

    @Override
    public void netInstanceDrawingClosed(String string) throws SQLException {
        try {
            logger.debug((Object)("Closed " + string));
            NetInstanceEntity netInstanceEntity = new NetInstanceEntity(this.connection, this.dialect);
            netInstanceEntity.load(string);
            netInstanceEntity.setDrawingOpen(new Integer(0));
            netInstanceEntity.save();
        }
        catch (NoSuchEntityException noSuchEntityException) {
            // empty catch block
        }
    }

    @Override
    public void netInstanceDrawingOpened(String string) throws SQLException {
        try {
            logger.debug((Object)("Opened " + string));
            NetInstanceEntity netInstanceEntity = new NetInstanceEntity(this.connection, this.dialect);
            netInstanceEntity.load(string);
            netInstanceEntity.setDrawingOpen(new Integer(1));
            netInstanceEntity.save();
        }
        catch (NoSuchEntityException noSuchEntityException) {
            // empty catch block
        }
    }

    @Override
    public void perform(NetAction[] netActionArray, TokenAction[] tokenActionArray, TokenAction[] tokenActionArray2, NetAction[] netActionArray2) throws SQLException, IllegalTokenException {
        this.createNets(netActionArray);
        this.addTokens(tokenActionArray);
        this.removeTokens(tokenActionArray2);
        this.deleteNets(netActionArray2);
        this.connection.commit();
    }

    private void removeTokens(TokenAction[] tokenActionArray) throws SQLException, IllegalTokenException {
        for (int i = 0; i < tokenActionArray.length; ++i) {
            TokenAction tokenAction = tokenActionArray[i];
            Object object = tokenAction.getToken();
            if (!(object instanceof Serializable)) {
                throw new IllegalTokenException("Token " + tokenAction.getTokenID() + " is not serializable.\n" + "Only serializable tokens can be handled" + " by the DatabaseTransactionStrategy.");
            }
            try {
                TokenEntity tokenEntity = new TokenEntity(this.connection, this.dialect);
                tokenEntity.load(tokenAction.getTokenID());
                TokenPositionEntity tokenPositionEntity = new TokenPositionEntity(this.connection, this.dialect);
                try {
                    tokenPositionEntity.load(new Object[]{tokenAction.getTokenID(), tokenAction.getNetID(), tokenAction.getPlaceID().toString()});
                    if (tokenPositionEntity.getQuantity() <= 1) {
                        tokenPositionEntity.delete();
                    } else {
                        tokenPositionEntity.setQuantity(new Integer(tokenPositionEntity.getQuantity() - 1));
                        tokenPositionEntity.save();
                    }
                }
                catch (NoSuchEntityException noSuchEntityException) {
                    // empty catch block
                }
                if (Entity.getEntities(tokenPositionEntity, "TOKEN_ID='" + tokenAction.getTokenID() + "'").size() > 0) continue;
                tokenEntity.delete();
                continue;
            }
            catch (NoSuchEntityException noSuchEntityException) {
                // empty catch block
            }
        }
    }

    @Override
    public void simulationStateChanged(boolean bl, boolean bl2) throws SQLException {
        StateEntity stateEntity = new StateEntity(this.connection, this.dialect);
        try {
            stateEntity.load(new Object[0]);
        }
        catch (NoSuchEntityException noSuchEntityException) {
            // empty catch block
        }
        stateEntity.setInited(new Integer(bl ? 1 : 0));
        stateEntity.setRunning(new Integer(bl2 ? 1 : 0));
        stateEntity.save();
        this.connection.commit();
    }
}

