/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.searcher;

import de.renew.engine.searcher.Triggerable;
import de.renew.engine.searcher.TriggerableCollection;
import de.renew.engine.simulator.SimulationThreadPool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class TriggerCollection
implements Serializable {
    private Set<TriggerableCollection> triggers;
    private Triggerable triggerable;

    public TriggerCollection(Triggerable triggerable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.triggers = new HashSet<TriggerableCollection>();
        this.triggerable = triggerable;
    }

    public void include(TriggerableCollection triggerableCollection) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.triggers.add(triggerableCollection);
    }

    public void exclude(TriggerableCollection triggerableCollection) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.triggers.remove(triggerableCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        ArrayList<TriggerableCollection> arrayList = new ArrayList<TriggerableCollection>();
        TriggerCollection triggerCollection = this;
        synchronized (triggerCollection) {
            arrayList.addAll(this.triggers);
        }
        for (TriggerableCollection triggerableCollection : arrayList) {
            triggerableCollection.exclude(this.triggerable);
        }
    }
}

