/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.searchqueue;

import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searchqueue.RandomQueueFactory;
import de.renew.engine.searchqueue.SearchQueueData;
import de.renew.engine.searchqueue.SearchQueueFactory;
import de.renew.engine.searchqueue.SearchQueueListener;
import de.renew.engine.searchqueue.TimeListener;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SearchQueue {
    public static Logger logger = Logger.getLogger(SearchQueue.class);
    private static double time = 0.0;
    private static SortedMap<Object, SearchQueueData> queueByTime = new TreeMap<Object, SearchQueueData>();
    private static Hashtable<Searchable, SearchQueueData> queueBySearchable = new Hashtable();
    private static SearchQueueFactory factory = new RandomQueueFactory();
    private static List<SearchQueueListener> listeners = new ArrayList<SearchQueueListener>();
    private static List<TimeListener> timeListeners = new ArrayList<TimeListener>();

    private SearchQueue() {
    }

    public static synchronized void setQueueFactory(SearchQueueFactory searchQueueFactory) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        factory = searchQueueFactory;
        queueBySearchable = new Hashtable();
        for (Object object : queueByTime.keySet()) {
            SearchQueueData searchQueueData = (SearchQueueData)queueByTime.get(object);
            SearchQueueData searchQueueData2 = factory.makeQueue(searchQueueData.getTime());
            Enumeration<Searchable> enumeration = searchQueueData.elements();
            while (enumeration.hasMoreElements()) {
                Searchable searchable = enumeration.nextElement();
                searchQueueData2.include(searchable);
                queueBySearchable.put(searchable, searchQueueData2);
            }
            queueByTime.put(object, searchQueueData2);
        }
    }

    private static void setTime(double d) {
        time = d;
        SearchQueue.notifyTimeListeners();
    }

    public static synchronized void reset(double d) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation threadbut instead: " + Thread.currentThread().getThreadGroup();
        queueByTime = new TreeMap<Object, SearchQueueData>();
        queueBySearchable = new Hashtable();
        SimulatorEventLogger.log("Setting time to " + d);
        SearchQueue.setTime(d);
    }

    public static synchronized double getTime() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return time;
    }

    private static void advanceTime(double d) {
        if (d > time) {
            logger.info((Object)("Advancing time to " + d));
            SearchQueue.setTime(d);
        }
    }

    private static SearchQueueData takeEarliestQueue() {
        if (queueByTime.isEmpty()) {
            return null;
        }
        Object object = queueByTime.firstKey();
        return (SearchQueueData)queueByTime.remove(object);
    }

    public static synchronized void advanceTime() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SearchQueueData searchQueueData = SearchQueue.takeEarliestQueue();
        if (searchQueueData != null) {
            SearchQueue.advanceTime(searchQueueData.getTime());
            queueByTime.put(new Double(searchQueueData.getTime()), searchQueueData);
        }
    }

    public static synchronized boolean isCurrentlyEmpty() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return !queueByTime.containsKey(new Double(time));
    }

    public static synchronized boolean isTotallyEmpty() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return queueByTime.isEmpty();
    }

    public static synchronized void insertListener(SearchQueueListener searchQueueListener) {
        listeners.add(searchQueueListener);
    }

    public static synchronized void insertTimeListener(TimeListener timeListener) {
        timeListeners.add(timeListener);
    }

    public static synchronized void removeTimeListener(TimeListener timeListener) {
        timeListeners.remove(timeListener);
    }

    private static void notifyListeners() {
        Iterator<SearchQueueListener> iterator = listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().searchQueueNonempty();
        }
        listeners.clear();
    }

    private static void notifyTimeListeners() {
        ArrayList<TimeListener> arrayList = new ArrayList<TimeListener>(timeListeners);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((TimeListener)iterator.next()).timeAdvanced();
        }
    }

    public static synchronized void includeNow(Searchable searchable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SearchQueue.include(searchable, time);
    }

    public static synchronized void include(Searchable searchable, double d) {
        SearchQueueData searchQueueData;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (d < time) {
            d = time;
        }
        if (d == time) {
            searchable.triggers().clear();
        }
        if ((searchQueueData = queueBySearchable.get(searchable)) != null && d < searchQueueData.getTime()) {
            searchQueueData.exclude(searchable);
            queueBySearchable.remove(searchable);
            if (searchQueueData.size() == 0) {
                queueByTime.remove(new Double(searchQueueData.getTime()));
            }
            searchQueueData = null;
        }
        if (searchQueueData == null) {
            Double d2 = new Double(d);
            if (queueByTime.containsKey(d2)) {
                searchQueueData = (SearchQueueData)queueByTime.get(d2);
            } else {
                searchQueueData = factory.makeQueue(d);
                queueByTime.put(d2, searchQueueData);
            }
            searchQueueData.include(searchable);
            queueBySearchable.put(searchable, searchQueueData);
        }
        SearchQueue.notifyListeners();
    }

    public static synchronized Searchable extract() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SearchQueueData searchQueueData = SearchQueue.takeEarliestQueue();
        if (searchQueueData == null) {
            return null;
        }
        SearchQueue.advanceTime(searchQueueData.getTime());
        Searchable searchable = searchQueueData.extract();
        queueBySearchable.remove(searchable);
        if (searchQueueData.size() > 0) {
            queueByTime.put(new Double(searchQueueData.getTime()), searchQueueData);
        }
        return searchable;
    }

    public static synchronized void saveQueue(ObjectOutput objectOutput) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RenewObjectOutputStream renewObjectOutputStream = null;
        if (objectOutput instanceof RenewObjectOutputStream) {
            renewObjectOutputStream = (RenewObjectOutputStream)objectOutput;
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.beginDomain(SearchQueue.class);
        }
        objectOutput.writeInt(queueByTime.size());
        for (Double d : queueByTime.keySet()) {
            objectOutput.writeDouble(d);
            SearchQueueData searchQueueData = (SearchQueueData)queueByTime.get(d);
            objectOutput.writeInt(searchQueueData.size());
            Enumeration<Searchable> enumeration = searchQueueData.elements();
            while (enumeration.hasMoreElements()) {
                objectOutput.writeObject(enumeration.nextElement());
            }
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.writeDelayedObjects();
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.endDomain(SearchQueue.class);
        }
    }

    public static synchronized void loadQueue(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        Vector<Object> vector = new Vector<Object>();
        Vector<Double> vector2 = new Vector<Double>();
        int n2 = objectInput.readInt();
        try {
            for (n = 0; n < n2; ++n) {
                Double d = new Double(objectInput.readDouble());
                int n3 = objectInput.readInt();
                for (int i = 0; i < n3; ++i) {
                    vector.addElement(objectInput.readObject());
                    vector2.addElement(d);
                }
            }
        }
        catch (ClassCastException classCastException) {
            logger.debug((Object)classCastException.getMessage(), (Throwable)classCastException);
            throw new StreamCorruptedException("Object other than Searchable found when looking for SearchQueue elements: " + classCastException.getMessage());
        }
        if (objectInput instanceof RenewObjectInputStream) {
            ((RenewObjectInputStream)objectInput).readDelayedObjects();
        }
        for (n = 0; n < vector.size(); ++n) {
            SearchQueue.include((Searchable)vector.elementAt(n), (Double)vector2.elementAt(n));
        }
    }
}

