/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.engine.simulator.SimulationThread;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.util.Semaphor;
import java.util.concurrent.Callable;

public class BlockingSimulationCallable<T>
implements Callable<T> {
    private Callable<T> task;
    private Semaphor notifier;
    private Thread ancestor;

    public BlockingSimulationCallable(Callable<T> callable, Semaphor semaphor, Thread thread) {
        this.task = callable;
        this.notifier = semaphor;
        this.ancestor = thread;
    }

    public Thread getAncestor() {
        return this.ancestor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        T t;
        try {
            if (SimulationThreadPool.logger.isTraceEnabled()) {
                SimulationThreadPool.logger.trace((Object)("Executing simulation callable now:          " + this.task + " in " + Thread.currentThread()));
            }
            t = this.task.call();
        }
        finally {
            this.abort((SimulationThread)Thread.currentThread());
        }
        return t;
    }

    protected void abort(SimulationThread simulationThread) {
        this.notifier.V();
        this.ancestor = null;
        if (simulationThread != null) {
            simulationThread.setAncestor(null);
        }
    }
}

