/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.engine.simulator.BlockingSimulationCallable;
import de.renew.engine.simulator.BlockingSimulationRunnable;
import de.renew.engine.simulator.SimulationThread;
import de.renew.engine.simulator.WrappedFutureTask;
import de.renew.util.ClassSource;
import de.renew.util.Semaphor;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class SimulationThreadPool
extends ThreadPoolExecutor {
    public static Logger logger = Logger.getLogger(SimulationThreadPool.class);
    private static final Object lock = new Object();
    private static SimulationThreadPool singleton = null;
    private static SimulationThreadPool newSingleton = null;
    private final SimulatorThreadFactory factory = (SimulatorThreadFactory)this.getThreadFactory();

    private SimulationThreadPool(int n) {
        super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new SimulatorThreadFactory());
    }

    public void executeAndWait(Runnable runnable) {
        if (this.isMyThread()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Running simulation runnable directly: " + runnable));
            }
            runnable.run();
        } else {
            Semaphor semaphor = new Semaphor();
            BlockingSimulationRunnable blockingSimulationRunnable = new BlockingSimulationRunnable(runnable, semaphor, Thread.currentThread());
            this.execute(blockingSimulationRunnable);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Running simulation runnable indirectly: " + runnable));
            }
            semaphor.P();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Running simulation runnable returned: " + runnable));
        }
    }

    public <T> Future<T> submitAndWait(Callable<T> callable) {
        Future<T> future = null;
        if (this.isMyThread()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Running simulation callable directly:      " + callable + " in " + Thread.currentThread()));
            }
            future = new FutureTask<T>(callable);
            future.run();
        } else {
            Semaphor semaphor = new Semaphor();
            BlockingSimulationCallable<T> blockingSimulationCallable = new BlockingSimulationCallable<T>(callable, semaphor, Thread.currentThread());
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Running simulation callable indirectly:     " + callable + " in " + Thread.currentThread()));
            }
            future = this.submit(blockingSimulationCallable);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Waiting for simulation callable completion: " + callable + " in " + Thread.currentThread()));
            }
            semaphor.P();
        }
        logger.trace((Object)("Running simulation callable returned:       " + callable + " in " + Thread.currentThread()));
        return future;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        RunnableFuture<T> runnableFuture = callable != null && callable instanceof BlockingSimulationCallable ? new WrappedFutureTask<T>((BlockingSimulationCallable)callable) : super.newTaskFor(callable);
        return runnableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimulationThreadPool getNew() {
        Object object = lock;
        synchronized (object) {
            if (newSingleton == null) {
                newSingleton = new SimulationThreadPool(5);
            }
            return newSingleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimulationThreadPool getCurrent() {
        Object object = lock;
        synchronized (object) {
            if (singleton == null) {
                singleton = new SimulationThreadPool(5);
            }
            return singleton;
        }
    }

    public static SimulationThreadPool getSimulationThreadPool() {
        return SimulationThreadPool.getCurrent();
    }

    public static boolean isSimulationThread() {
        return singleton != null && singleton.isMyThread();
    }

    public boolean isMyThread() {
        return Thread.currentThread().getThreadGroup().equals(this.factory.getThreadGroup());
    }

    public boolean isMyThread(Thread thread) {
        return thread.getThreadGroup().equals(this.factory.getThreadGroup());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cleanup() {
        Object object = lock;
        synchronized (object) {
            SimulationThreadPool simulationThreadPool = singleton;
            singleton = newSingleton;
            newSingleton = null;
            simulationThreadPool.shutdownNow();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void discardNew() {
        Object object = lock;
        synchronized (object) {
            SimulationThreadPool simulationThreadPool = newSingleton;
            newSingleton = null;
            simulationThreadPool.shutdown();
        }
    }

    public void setMaxPriority(int n) {
        this.factory.setMaxPriority(n);
    }

    public int getMaxPriority() {
        return this.factory.getMaxPriority();
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        SimulationThread simulationThread = (SimulationThread)thread;
        if (runnable instanceof BlockingSimulationRunnable) {
            simulationThread.setAncestor(((BlockingSimulationRunnable)runnable).getAncestor());
        } else if (runnable instanceof WrappedFutureTask) {
            WrappedFutureTask wrappedFutureTask = (WrappedFutureTask)runnable;
            simulationThread.setAncestor(wrappedFutureTask.callable.getAncestor());
        }
    }

    static class SimulatorThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;
        final ClassLoader classLoader;

        public SimulatorThreadFactory() {
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            while (threadGroup.getParent() != null) {
                threadGroup = threadGroup.getParent();
            }
            this.group = new ThreadGroup("simulation-thread-group");
            this.namePrefix = "simulation-thread-";
            this.classLoader = ClassSource.getClassLoader();
        }

        @Override
        public Thread newThread(Runnable runnable) {
            SimulationThread simulationThread = new SimulationThread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0);
            simulationThread.setContextClassLoader(this.classLoader);
            if (simulationThread.isDaemon()) {
                simulationThread.setDaemon(false);
            }
            if (simulationThread.getPriority() != 5) {
                simulationThread.setPriority(5);
            }
            assert (simulationThread.getThreadGroup().equals(this.getThreadGroup())) : "Thread must belong to thread group of factory";
            return simulationThread;
        }

        public ThreadGroup getThreadGroup() {
            return this.group;
        }

        public void setMaxPriority(int n) {
            this.group.setMaxPriority(n);
        }

        public int getMaxPriority() {
            return this.group.getMaxPriority();
        }
    }
}

