/*
 * Decompiled with CFR 0.152.
 */
package de.renew.expression;

import de.renew.expression.Expression;
import de.renew.expression.ExpressionWithTypeField;
import de.renew.expression.Function;
import de.renew.expression.VariableMapper;
import de.renew.unify.CalculationChecker;
import de.renew.unify.Impossible;
import de.renew.unify.Notifiable;
import de.renew.unify.StateRecorder;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.Types;

public class CallExpression
extends ExpressionWithTypeField {
    Expression argument;
    Function function;

    public CallExpression(Class<?> clazz, Expression expression, Function function) {
        super(clazz);
        this.argument = expression;
        this.function = function;
    }

    @Override
    public boolean isInvertible() {
        return false;
    }

    @Override
    public Object startEvaluation(VariableMapper variableMapper, StateRecorder stateRecorder, CalculationChecker calculationChecker) throws Impossible {
        Variable variable = new Variable(this.argument.startEvaluation(variableMapper, stateRecorder, calculationChecker), stateRecorder);
        Variable variable2 = new Variable();
        if (calculationChecker != null) {
            calculationChecker.addEarlyVariable(variable, stateRecorder);
        }
        CallExpression.expressionConstraint(variable2, this.function, variable, stateRecorder);
        return variable2.getValue();
    }

    @Override
    public Object registerCalculation(VariableMapper variableMapper, StateRecorder stateRecorder, CalculationChecker calculationChecker) throws Impossible {
        Variable variable = new Variable(this.argument.registerCalculation(variableMapper, stateRecorder, calculationChecker), stateRecorder);
        Variable variable2 = new Variable();
        calculationChecker.addLateVariable(variable, stateRecorder);
        calculationChecker.addCalculated(this.getType(), variable2, variable.getValue(), stateRecorder);
        return variable2.getValue();
    }

    public static void expressionConstraint(final Variable variable, final Function function, final Variable variable2, StateRecorder stateRecorder) throws Impossible {
        Notifiable notifiable = new Notifiable(){

            @Override
            public void boundNotify(StateRecorder stateRecorder) throws Impossible {
                if (Unify.isBound(variable2)) {
                    Unify.unify(variable, function.function(variable2.getValue()), stateRecorder);
                }
            }
        };
        variable2.addListener(notifiable, stateRecorder);
    }

    public String toString() {
        return "CallExpr(" + Types.typeToString((Class)this.getType()) + ": " + this.function + ", " + this.argument + ")";
    }
}

