/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.application.SimulatorPlugin;
import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.events.NetInstantiationException;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.NetElementID;
import de.renew.net.NetInstance;
import de.renew.net.NetInstanceImpl;
import de.renew.net.NetNotFoundException;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.net.loading.NetLoader;
import de.renew.unify.Impossible;
import de.renew.util.ClassSource;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class Net
implements Serializable {
    public static Logger logger = Logger.getLogger(Net.class);
    static final long serialVersionUID = 4424943946669800287L;
    private static Map<String, Net> netsByName = new HashMap<String, Net>();
    private static NetLoader netLoader = null;
    Set<Place> places = new HashSet<Place>();
    Set<Transition> transitions = new HashSet<Transition>();
    Map<NetElementID, Place> placesByID = new HashMap<NetElementID, Place>();
    Map<NetElementID, Transition> transitionsByID = new HashMap<NetElementID, Transition>();
    String name = null;
    boolean earlyTokens = false;
    private int netCount = 0;

    public Net() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.name = null;
    }

    public Net(String string) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Net forName(final String string) throws NetNotFoundException {
        SimulatorPlugin.lock.lock();
        try {
            Future<Net> future = SimulationThreadPool.getCurrent().submitAndWait(new Callable<Net>(){

                @Override
                public Net call() throws Exception {
                    Net net = (Net)netsByName.get(string);
                    if (net == null) {
                        if (netLoader == null) {
                            throw new NetNotFoundException(string);
                        }
                        net = (Net)netsByName.get(string);
                        if (net == null) {
                            net = netLoader.loadNet(string);
                        }
                    }
                    return net;
                }
            });
            Net net = future.get();
            return net;
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof NetNotFoundException) {
                throw (NetNotFoundException)throwable;
            }
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        finally {
            SimulatorPlugin.lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forgetAllNets() {
        SimulatorPlugin.lock.lock();
        try {
            netsByName.clear();
        }
        finally {
            SimulatorPlugin.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setNetLoader(NetLoader netLoader) {
        block4: {
            SimulatorPlugin.lock.lock();
            try {
                if (netsByName.isEmpty()) {
                    Net.netLoader = netLoader;
                    break block4;
                }
                throw new IllegalStateException("Cannot change net loader while nets are known.");
            }
            finally {
                SimulatorPlugin.lock.unlock();
            }
        }
    }

    public static NetLoader getNetLoader() {
        return netLoader;
    }

    public static Iterator<Net> allKnownNets() {
        return netsByName.values().iterator();
    }

    public static boolean isKnownNet(String string) {
        return netsByName.containsKey(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeKnown() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorPlugin.lock.lock();
        try {
            if (this.name != null) {
                netsByName.put(this.name, this);
            }
        }
        finally {
            SimulatorPlugin.lock.unlock();
        }
    }

    public Collection<Place> places() {
        return this.places;
    }

    public int placeCount() {
        return this.places.size();
    }

    public Collection<Transition> transitions() {
        return this.transitions;
    }

    public int transitionCount() {
        return this.transitions.size();
    }

    synchronized int makeNetNumber() {
        return ++this.netCount;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public NetInstance makeInstance() throws Impossible {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return new NetInstanceImpl(this);
    }

    public NetInstance buildInstance(StepIdentifier stepIdentifier) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        NetInstance netInstance = null;
        try {
            netInstance = this.makeInstance();
            netInstance.createConfirmation(stepIdentifier);
            return netInstance;
        }
        catch (Impossible impossible) {
            RuntimeException runtimeException = new RuntimeException("Could not make instance of net " + this.getName() + ".", impossible);
            SimulatorEventLogger.log(stepIdentifier, new NetInstantiationException(this, impossible));
            throw runtimeException;
        }
    }

    public NetInstance buildInstance() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this.buildInstance(SimulatorPlugin.getCurrent().getCurrentEnvironment().getSimulator().currentStepIdentifier());
    }

    void add(Place place) {
        NetElementID netElementID = place.getID();
        assert (!this.places.contains(place)) : "Tried to add existing place: " + place;
        assert (!this.placesByID.containsKey(netElementID)) : "Tried to add place with existing ID: " + netElementID + ", old: " + this.placesByID.get(netElementID) + ", new: " + place;
        this.places.add(place);
        this.placesByID.put(netElementID, place);
    }

    void add(Transition transition) {
        NetElementID netElementID = transition.getID();
        assert (!this.transitions.contains(transition)) : "Tried to add existing transition: " + transition;
        assert (!this.transitionsByID.containsKey(netElementID)) : "Tried to add transition with existing ID: " + netElementID + ", old: " + this.transitionsByID.get(netElementID) + ", new: " + transition;
        this.transitions.add(transition);
        this.transitionsByID.put(netElementID, transition);
    }

    void remove(Place place) {
        this.places.remove(place);
        this.placesByID.remove(place.getID());
    }

    void remove(Transition transition) {
        this.transitions.remove(transition);
        this.transitionsByID.remove(transition.getID());
    }

    public void setEarlyTokens(boolean bl) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.earlyTokens = bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RenewObjectOutputStream renewObjectOutputStream = null;
        if (objectOutputStream instanceof RenewObjectOutputStream) {
            renewObjectOutputStream = (RenewObjectOutputStream)objectOutputStream;
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.beginDomain((Object)this);
        }
        objectOutputStream.defaultWriteObject();
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.endDomain((Object)this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        RenewObjectInputStream renewObjectInputStream;
        objectInputStream.defaultReadObject();
        if (objectInputStream instanceof RenewObjectInputStream && (renewObjectInputStream = (RenewObjectInputStream)objectInputStream).isCopiousBehaviour()) {
            StringBuffer stringBuffer = new StringBuffer(this.name);
            while (Net.isKnownNet(stringBuffer.toString())) {
                stringBuffer.append("_COPY");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Deserialized Net copy: changed name from " + this.name + " to " + stringBuffer + "."));
            }
            this.name = stringBuffer.toString();
        }
        this.makeKnown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAllNets(ObjectOutput objectOutput) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorPlugin.lock.lock();
        try {
            RenewObjectOutputStream renewObjectOutputStream = null;
            if (objectOutput instanceof RenewObjectOutputStream) {
                renewObjectOutputStream = (RenewObjectOutputStream)objectOutput;
            }
            if (renewObjectOutputStream != null) {
                renewObjectOutputStream.beginDomain(Net.class);
            }
            objectOutput.writeInt(netsByName.size());
            Iterator<Net> iterator = netsByName.values().iterator();
            while (iterator.hasNext()) {
                objectOutput.writeObject(iterator.next());
            }
            if (renewObjectOutputStream != null) {
                renewObjectOutputStream.writeDelayedObjects();
            }
            if (renewObjectOutputStream != null) {
                renewObjectOutputStream.endDomain(Net.class);
            }
        }
        finally {
            SimulatorPlugin.lock.unlock();
        }
    }

    public static void loadNets(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        int n = objectInput.readInt();
        try {
            for (int i = 0; i < n; ++i) {
                ClassSource.readObject((ObjectInput)objectInput);
            }
        }
        catch (ClassCastException classCastException) {
            logger.debug((Object)classCastException.getMessage(), (Throwable)classCastException);
            throw new StreamCorruptedException("Object other than Net found when looking for nets: " + classCastException.getMessage());
        }
        if (objectInput instanceof RenewObjectInputStream) {
            ((RenewObjectInputStream)objectInput).readDelayedObjects();
        }
    }

    public Place getPlaceWithID(NetElementID netElementID) {
        return this.placesByID.get(netElementID);
    }

    public Transition getTransitionWithID(NetElementID netElementID) {
        return this.transitionsByID.get(netElementID);
    }
}

