/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.database.Transaction;
import de.renew.database.TransactionSource;
import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.events.TraceEvent;
import de.renew.engine.searcher.TriggerableCollection;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.expression.LocalVariable;
import de.renew.expression.VariableMapper;
import de.renew.net.IDRegistry;
import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.net.TimeSet;
import de.renew.net.TokenSource;
import de.renew.net.event.PlaceEventListener;
import de.renew.net.event.PlaceEventListenerSet;
import de.renew.net.event.PlaceEventProducer;
import de.renew.unify.Impossible;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.DelayedFieldOwner;
import de.renew.util.Lock;
import de.renew.util.Orderer;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class PlaceInstance
implements PlaceEventProducer,
Serializable,
DelayedFieldOwner {
    public static Logger logger = Logger.getLogger(PlaceInstance.class);
    static final long serialVersionUID = 562364463914372791L;
    protected NetInstance netInstance;
    protected Place place;
    protected List<Object> initTokens;
    protected boolean earlyTokens;
    protected transient TriggerableCollection triggerables;
    public transient long lockOrder;
    public transient Lock lock;
    protected transient PlaceEventListenerSet listeners = new PlaceEventListenerSet();

    PlaceInstance(NetInstance netInstance, Place place, boolean bl) throws Impossible {
        this.netInstance = netInstance;
        this.place = place;
        this.lockOrder = Orderer.getTicket();
        this.lock = new Lock();
        this.triggerables = new TriggerableCollection();
        this.initTokenStorage();
        this.earlyTokens = netInstance.getNet().earlyTokens;
        this.initTokens = new ArrayList<Object>();
        for (TokenSource tokenSource : place.inscriptions) {
            VariableMapper variableMapper = new VariableMapper();
            Variable variable = variableMapper.map(new LocalVariable("this", false));
            Unify.unify(variable, netInstance, null);
            Object object = tokenSource.createToken(variableMapper);
            this.initTokens.add(object);
            if (!this.earlyTokens) continue;
            this.internallyInsertToken(object, SearchQueue.getTime(), false);
        }
    }

    protected abstract void initTokenStorage();

    public String toString() {
        return this.netInstance.toString() + "." + this.place.toString();
    }

    public NetInstance getNetInstance() {
        return this.netInstance;
    }

    public Place getPlace() {
        return this.place;
    }

    public TriggerableCollection triggerables() {
        return this.triggerables;
    }

    @Override
    public void addPlaceEventListener(PlaceEventListener placeEventListener) {
        this.listeners.addPlaceEventListener(placeEventListener);
    }

    @Override
    public void removePlaceEventListener(PlaceEventListener placeEventListener) {
        this.listeners.removePlaceEventListener(placeEventListener);
    }

    public abstract Set<Object> getDistinctTokens();

    public abstract Set<Object> getDistinctTokens(Object var1);

    public abstract Set<Object> getDistinctTestableTokens();

    public abstract Set<Object> getDistinctTestableTokens(Object var1);

    public abstract int getNumberOfTokens();

    public abstract int getNumberOfTestedTokens();

    public abstract boolean isEmpty();

    abstract boolean containsToken(Object var1);

    public abstract int getTokenCount(Object var1);

    public abstract TimeSet getFreeTimeSet(Object var1);

    public abstract double computeEarliestTime(Object var1, TimeSet var2);

    public abstract boolean containsTestedToken(Object var1);

    public abstract boolean containsTestableToken(Object var1);

    protected IDRegistry registry() {
        return this.netInstance.getRegistry();
    }

    public void reserve(Object object) {
        this.registry().reserve(object);
    }

    public String getTokenID(Object object) {
        return this.registry().getID(object);
    }

    public void unreserve(Object object) {
        this.registry().unreserve(object);
    }

    public abstract double removeToken(Object var1, double var2) throws Impossible;

    public abstract double testToken(Object var1) throws Impossible;

    public abstract void extractAllTokens(Vector<Object> var1, Vector<Double> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTokenWithID(Object object, String string, double d) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.lock.lock();
        try {
            this.registry().setAndReserveID(object, string);
            this.internallyInsertToken(object, d, true);
        }
        finally {
            this.lock.unlock();
        }
    }

    public abstract void internallyInsertToken(Object var1, double var2, boolean var4);

    public void transactionInsertToken(Object object, double d, boolean bl) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        Transaction transaction = TransactionSource.get();
        try {
            transaction.addToken(this, object, d, bl);
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public void insertToken(Object object, double d) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.transactionInsertToken(object, d, true);
    }

    public abstract void untestToken(Object var1);

    private void traceInitialTokens(StepIdentifier stepIdentifier) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        for (Object object : this.initTokens) {
            if (!this.place.getTrace()) continue;
            SimulatorEventLogger.log(stepIdentifier, (SimulationEvent)new TraceEvent("Initializing " + object + " into " + this), this);
        }
    }

    void earlyConfirmation() {
        if (this.earlyTokens) {
            for (Object object : this.initTokens) {
                double d = SearchQueue.getTime();
                this.transactionInsertToken(object, d, false);
            }
        }
    }

    void earlyConfirmationTrace(StepIdentifier stepIdentifier) {
        if (this.earlyTokens) {
            this.traceInitialTokens(stepIdentifier);
        }
    }

    void lateConfirmation(StepIdentifier stepIdentifier) {
        if (!this.earlyTokens) {
            this.traceInitialTokens(stepIdentifier);
            for (Object object : this.initTokens) {
                this.insertToken(object, SearchQueue.getTime());
            }
        }
        this.initTokens = null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RenewObjectOutputStream renewObjectOutputStream = null;
        if (objectOutputStream instanceof RenewObjectOutputStream) {
            renewObjectOutputStream = (RenewObjectOutputStream)objectOutputStream;
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.beginDomain((Object)this);
        }
        objectOutputStream.defaultWriteObject();
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.delayedWriteObject((Object)this.triggerables, (DelayedFieldOwner)this);
            renewObjectOutputStream.endDomain((Object)this);
        } else {
            objectOutputStream.writeObject(this.triggerables);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.lockOrder = Orderer.getTicket();
        this.lock = new Lock();
        this.listeners = new PlaceEventListenerSet();
        if (!(objectInputStream instanceof RenewObjectInputStream)) {
            this.triggerables = (TriggerableCollection)objectInputStream.readObject();
        }
    }

    public abstract void reassignField(Object var1) throws IOException;

    protected boolean tryReassignField(Object object) throws IOException {
        if (object instanceof TriggerableCollection) {
            this.triggerables = (TriggerableCollection)object;
            return true;
        }
        return false;
    }
}

