/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.PlaceInstance;
import de.renew.net.TestTokenBag;
import de.renew.net.TimeSet;
import de.renew.net.TokenBag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

class TokenReservation {
    private PlaceInstance instance;
    private int reservations;
    private TestTokenBag testedTokens;
    private TokenBag removedTokenDelays;

    TokenReservation(PlaceInstance placeInstance) {
        this.instance = placeInstance;
        this.reservations = 0;
        this.testedTokens = new TestTokenBag();
        this.removedTokenDelays = new TokenBag();
    }

    boolean isRemovable() {
        return this.reservations == 0;
    }

    private TimeSet getRemovedDelaySet(Object object, boolean bl) {
        TimeSet timeSet = this.removedTokenDelays.getTimeSet(object);
        if (bl && !this.instance.containsTestedToken(object)) {
            timeSet = timeSet.including(0.0);
        }
        return timeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double computeEarliestTime() {
        double d;
        this.instance.lock.lock();
        try {
            d = 0.0;
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.addAll(this.testedTokens.uniqueElements());
            hashSet.addAll(this.removedTokenDelays.uniqueElements());
            for (Object e : hashSet) {
                boolean bl = this.testedTokens.getTestMultiplicity(e) > 0;
                TimeSet timeSet = this.getRemovedDelaySet(e, bl);
                double d2 = this.instance.computeEarliestTime(e, timeSet);
                if (!(d2 > d)) continue;
                d = d2;
            }
        }
        finally {
            this.instance.lock.unlock();
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsRemovableToken(Object object, double d) {
        boolean bl;
        this.instance.lock.lock();
        try {
            TimeSet timeSet = this.getRemovedDelaySet(object, this.testedTokens.getTestMultiplicity(object) > 0).including(d);
            double d2 = this.instance.computeEarliestTime(object, timeSet);
            bl = d2 < Double.POSITIVE_INFINITY;
        }
        finally {
            this.instance.lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsTestableToken(Object object) {
        boolean bl;
        this.instance.lock.lock();
        try {
            TimeSet timeSet = this.getRemovedDelaySet(object, true);
            double d = this.instance.computeEarliestTime(object, timeSet);
            bl = d < Double.POSITIVE_INFINITY;
        }
        finally {
            this.instance.lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeToken(Object object, double d) {
        boolean bl;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.instance.lock.lock();
        try {
            bl = this.containsRemovableToken(object, d);
            if (bl) {
                this.removedTokenDelays.add(object, d);
                ++this.reservations;
            }
        }
        finally {
            this.instance.lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testToken(Object object) {
        boolean bl;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.instance.lock.lock();
        try {
            bl = this.containsTestableToken(object);
            if (bl) {
                this.testedTokens.addTested(object, 0.0);
                ++this.reservations;
            }
        }
        finally {
            this.instance.lock.unlock();
        }
        return bl;
    }

    public void unremoveToken(Object object, double d) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.removedTokenDelays.removeOneOf(object, d);
        --this.reservations;
    }

    public void untestToken(Object object) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.testedTokens.removeTested(object);
        --this.reservations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> getRemovableTokens(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.instance.lock.lock();
        try {
            for (Object object2 : this.instance.getDistinctTokens(object)) {
                if (!this.containsRemovableToken(object2, Double.NEGATIVE_INFINITY)) continue;
                arrayList.add(object2);
            }
        }
        finally {
            this.instance.lock.unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> getTestableTokens(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.instance.lock.lock();
        try {
            for (Object object2 : this.instance.getDistinctTestableTokens(object)) {
                if (!this.containsTestableToken(object2)) continue;
                arrayList.add(object2);
            }
        }
        finally {
            this.instance.lock.unlock();
        }
        return arrayList;
    }
}

