/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.searcher.DeltaSet;
import de.renew.engine.searcher.DeltaSetFactory;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.PlaceInstance;
import de.renew.net.TokenReservation;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;

public class TokenReserver
implements DeltaSet {
    private static final Factory FACTORY = new Factory();
    Hashtable<PlaceInstance, TokenReservation> reservations = new Hashtable();

    public static TokenReserver getInstance(Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return (TokenReserver)searcher.getDeltaSet(FACTORY);
    }

    TokenReserver() {
    }

    public void reset() {
        this.reservations = new Hashtable();
    }

    @Override
    public double computeEarliestTime() {
        double d = 0.0;
        Enumeration<TokenReservation> enumeration = this.reservations.elements();
        while (enumeration.hasMoreElements()) {
            TokenReservation tokenReservation = enumeration.nextElement();
            double d2 = tokenReservation.computeEarliestTime();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    private TokenReservation getReservation(PlaceInstance placeInstance) {
        if (this.reservations.containsKey(placeInstance)) {
            return this.reservations.get(placeInstance);
        }
        TokenReservation tokenReservation = new TokenReservation(placeInstance);
        this.reservations.put(placeInstance, tokenReservation);
        return tokenReservation;
    }

    private void disposeReservation(PlaceInstance placeInstance) {
        TokenReservation tokenReservation = this.reservations.get(placeInstance);
        if (tokenReservation.isRemovable()) {
            this.reservations.remove(placeInstance);
        }
    }

    public synchronized boolean containsRemovableToken(PlaceInstance placeInstance, Object object, double d) {
        TokenReservation tokenReservation = this.getReservation(placeInstance);
        boolean bl = tokenReservation.containsRemovableToken(object, d);
        this.disposeReservation(placeInstance);
        return bl;
    }

    public synchronized boolean containsTestableToken(PlaceInstance placeInstance, Object object) {
        TokenReservation tokenReservation = this.getReservation(placeInstance);
        boolean bl = tokenReservation.containsTestableToken(object);
        this.disposeReservation(placeInstance);
        return bl;
    }

    public synchronized boolean removeToken(PlaceInstance placeInstance, Object object, double d) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        TokenReservation tokenReservation = this.getReservation(placeInstance);
        boolean bl = tokenReservation.removeToken(object, d);
        this.disposeReservation(placeInstance);
        return bl;
    }

    public synchronized boolean testToken(PlaceInstance placeInstance, Object object) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        TokenReservation tokenReservation = this.getReservation(placeInstance);
        boolean bl = tokenReservation.testToken(object);
        this.disposeReservation(placeInstance);
        return bl;
    }

    public synchronized void unremoveToken(PlaceInstance placeInstance, Object object, double d) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        TokenReservation tokenReservation = this.getReservation(placeInstance);
        tokenReservation.unremoveToken(object, d);
        this.disposeReservation(placeInstance);
    }

    public synchronized void untestToken(PlaceInstance placeInstance, Object object) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        TokenReservation tokenReservation = this.getReservation(placeInstance);
        tokenReservation.untestToken(object);
        this.disposeReservation(placeInstance);
    }

    public synchronized Collection<Object> getRemovableTokens(PlaceInstance placeInstance, Object object) {
        TokenReservation tokenReservation = this.getReservation(placeInstance);
        Collection<Object> collection = tokenReservation.getRemovableTokens(object);
        this.disposeReservation(placeInstance);
        return collection;
    }

    public synchronized Collection<Object> getTestableTokens(PlaceInstance placeInstance, Object object) {
        TokenReservation tokenReservation = this.getReservation(placeInstance);
        Collection<Object> collection = tokenReservation.getTestableTokens(object);
        this.disposeReservation(placeInstance);
        return collection;
    }

    private static class Factory
    implements DeltaSetFactory {
        private Factory() {
        }

        @Override
        public String getCategory() {
            return "de.renew.nets.TokenReserver";
        }

        @Override
        public DeltaSet createDeltaSet() {
            return new TokenReserver();
        }
    }
}

