/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.arc;

import de.renew.engine.searcher.AbstractOccurrence;
import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.Executable;
import de.renew.engine.searcher.OccurrenceDescription;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.VariableMapperCopier;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.net.PlaceInstance;
import de.renew.net.arc.Arc;
import de.renew.net.arc.ArcAssignBinder;
import de.renew.net.arc.InhibitorArcBinder;
import de.renew.net.arc.InhibitorExecutable;
import de.renew.net.arc.InputArcBinder;
import de.renew.net.arc.InputArcExecutable;
import de.renew.net.arc.OutputArcExecutable;
import de.renew.net.arc.TestArcBinder;
import de.renew.net.arc.TestArcExecutable;
import de.renew.net.arc.UntestArcExecutable;
import de.renew.unify.Copier;
import de.renew.unify.Impossible;
import de.renew.unify.Variable;
import de.renew.util.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;

public class ArcOccurrence
extends AbstractOccurrence {
    static Variable theNullTimeVar = new Variable(new Value((Object)new Double(0.0)), null);
    PlaceInstance placeInstance;
    VariableMapper mapper;
    Variable tokenVar;
    Variable delayVar;
    Arc arc;

    protected ArcOccurrence(Arc arc, VariableMapper variableMapper, NetInstance netInstance) {
        super(netInstance.getInstance(arc.transition));
        this.arc = arc;
        this.mapper = variableMapper;
        this.placeInstance = netInstance.getInstance(arc.place);
    }

    protected InhibitorArcBinder getInhibitorArcBinder(Variable variable, PlaceInstance placeInstance) {
        return new InhibitorArcBinder(variable, placeInstance);
    }

    @Override
    public Collection<Binder> makeBinders(Searcher searcher) throws Impossible {
        this.tokenVar = new Variable(this.arc.tokenExpr.startEvaluation(this.mapper, searcher.recorder, searcher.calcChecker), searcher.recorder);
        if (!this.arc.isUntimedArc()) {
            this.delayVar = new Variable(this.arc.timeExpr.startEvaluation(this.mapper, searcher.recorder, searcher.calcChecker), searcher.recorder);
        }
        ArrayList<Binder> arrayList = new ArrayList<Binder>();
        if (this.arc.arcType == 1) {
            searcher.calcChecker.addLateVariable(this.tokenVar, searcher.recorder);
            searcher.calcChecker.addLateVariable(this.delayVar, searcher.recorder);
        } else if (this.arc.arcType == 5) {
            arrayList.add(this.getInhibitorArcBinder(this.tokenVar, this.placeInstance));
        } else {
            if (this.arc.tokenExpr.isInvertible()) {
                arrayList.add(new ArcAssignBinder(this.tokenVar, this.placeInstance, this.arc.isTestArc()));
            }
            if (this.arc.isTestArc()) {
                arrayList.add(new TestArcBinder(this.tokenVar, this.placeInstance));
            } else if (this.arc.arcType == 6) {
                arrayList.add(new InputArcBinder(this.tokenVar, new Variable(new Integer(0), null), this.placeInstance));
                searcher.calcChecker.addLateVariable(this.delayVar, searcher.recorder);
            } else {
                arrayList.add(new InputArcBinder(this.tokenVar, this.delayVar, this.placeInstance));
            }
        }
        return arrayList;
    }

    private double getDelay() {
        Object object = this.delayVar.getValue();
        if (object instanceof Value) {
            object = ((Value)object).value;
        }
        return ((Number)object).doubleValue();
    }

    @Override
    public Collection<Executable> makeExecutables(VariableMapperCopier variableMapperCopier) {
        Copier copier = variableMapperCopier.getCopier();
        Variable variable = (Variable)copier.copy(this.tokenVar);
        Vector<Executable> vector = new Vector<Executable>();
        switch (this.arc.arcType) {
            case -1: {
                vector.add(new InputArcExecutable(this.placeInstance, this.getTransition(), variable.getValue(), this.getDelay(), false, this.arc.getTrace()));
                return vector;
            }
            case 0: {
                TestArcExecutable testArcExecutable = new TestArcExecutable(this.placeInstance, this.getTransition(), variable.getValue(), false, this.arc.getTrace());
                return Arrays.asList(testArcExecutable, new UntestArcExecutable(testArcExecutable));
            }
            case 1: {
                Variable variable2 = (Variable)copier.copy(this.delayVar);
                vector.add(new OutputArcExecutable(this.placeInstance, this.getTransition(), variable, variable2, this.arc.getTrace()));
                return vector;
            }
            case 2: {
                return Arrays.asList(new InputArcExecutable(this.placeInstance, this.getTransition(), variable.getValue(), this.getDelay(), false, this.arc.getTrace()), new OutputArcExecutable(this.placeInstance, this.getTransition(), variable, null, this.arc.getTrace()));
            }
            case 3: {
                vector.add(new InputArcExecutable(this.placeInstance, this.getTransition(), variable.getValue(), this.getDelay(), true, this.arc.getTrace()));
                return vector;
            }
            case 4: {
                vector.add(new TestArcExecutable(this.placeInstance, this.getTransition(), variable.getValue(), true, this.arc.getTrace()));
                return vector;
            }
            case 5: {
                vector.add(new InhibitorExecutable(this.placeInstance, this.getTransition(), variable.getValue(), this.arc.getTrace()));
                return vector;
            }
            case 6: {
                Variable variable3 = (Variable)copier.copy(this.delayVar);
                return Arrays.asList(new InputArcExecutable(this.placeInstance, this.getTransition(), variable.getValue(), 0.0, false, this.arc.getTrace()), new OutputArcExecutable(this.placeInstance, this.getTransition(), variable, variable3, this.arc.getTrace()));
            }
        }
        throw new RuntimeException("Bad arc type.");
    }

    @Override
    public OccurrenceDescription makeOccurrenceDescription(VariableMapperCopier variableMapperCopier) {
        return null;
    }
}

