/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.arc;

import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.Searcher;
import de.renew.net.TokenReserver;
import de.renew.net.arc.FlexibleArcOccurrence;
import de.renew.unify.List;
import de.renew.unify.Unify;
import de.renew.util.Value;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

class FlexibleArcBinder
implements Binder {
    public static Logger logger = Logger.getLogger(FlexibleArcBinder.class);
    FlexibleArcOccurrence occurrence;

    FlexibleArcBinder(FlexibleArcOccurrence flexibleArcOccurrence) {
        this.occurrence = flexibleArcOccurrence;
    }

    @Override
    public int bindingBadness(Searcher searcher) {
        if (Unify.isBound(this.occurrence.tokenVar)) {
            return 1;
        }
        return 10000;
    }

    private void rememberSingleToken(Object object) {
        this.occurrence.inTokens.addElement(Unify.copyBoundValue(object));
    }

    @Override
    public void bind(Searcher searcher) {
        int n;
        if (!Unify.isBound(this.occurrence.tokenVar)) {
            throw new RuntimeException("Flexible arc binder was invoked for an incomplete value.");
        }
        Object object = this.occurrence.tokenVar.getValue();
        this.occurrence.inTokens = new Vector();
        if (object != null) {
            Object object2;
            if (object.getClass().isArray()) {
                object2 = object.getClass().getComponentType();
                n = Array.getLength(object);
                for (int i = 0; i < n; ++i) {
                    Object object3 = null;
                    try {
                        object3 = Array.get(object, i);
                        if (((Class)object2).isPrimitive()) {
                            object3 = new Value(object3);
                        }
                        if (this.occurrence.arc.forwardFunction != null) {
                            Object object4 = this.occurrence.arc.forwardFunction.function(object3);
                            if (this.occurrence.arc.backwardFunction != null) {
                                Object object5 = this.occurrence.arc.backwardFunction.function(object4);
                                Unify.unify(object3, object5, null);
                            }
                            object3 = object4;
                        }
                        this.rememberSingleToken(object3);
                        continue;
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
            } else if (object instanceof List) {
                object2 = (List)object;
                while (!((List)object2).isNull()) {
                    this.rememberSingleToken(((List)object2).head());
                    if (((List)object2).tail() instanceof List) {
                        object2 = (List)((List)object2).tail();
                        continue;
                    }
                    break;
                }
            } else if (object instanceof Collection) {
                object2 = (Collection)object;
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    this.rememberSingleToken(iterator.next());
                }
            }
        }
        if (!this.occurrence.arc.isOutputArc() && this.occurrence.inTokens.size() > 0) {
            searcher.insertTriggerable(this.occurrence.placeInstance.triggerables());
        }
        boolean bl = true;
        n = 0;
        TokenReserver tokenReserver = TokenReserver.getInstance(searcher);
        while (bl && n < this.occurrence.inTokens.size()) {
            try {
                bl = tokenReserver.removeToken(this.occurrence.placeInstance, this.occurrence.inTokens.elementAt(n), 0.0);
                if (!bl) continue;
                ++n;
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
                bl = false;
            }
        }
        if (bl) {
            searcher.search();
        }
        while (n > 0) {
            tokenReserver.unremoveToken(this.occurrence.placeInstance, this.occurrence.inTokens.elementAt(--n), 0.0);
        }
        this.occurrence.inTokens = null;
    }
}

