/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.arc;

import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.events.QuicklyTesting;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.events.Testing;
import de.renew.engine.searcher.EarlyExecutable;
import de.renew.net.PlaceInstance;
import de.renew.net.TransitionInstance;
import de.renew.unify.Impossible;

class TestArcExecutable
implements EarlyExecutable {
    PlaceInstance pInstance;
    TransitionInstance tInstance;
    Object token;
    boolean trace;
    boolean releaseImmediately;

    TestArcExecutable(PlaceInstance placeInstance, TransitionInstance transitionInstance, Object object, boolean bl, boolean bl2) {
        this.pInstance = placeInstance;
        this.tInstance = transitionInstance;
        this.token = object;
        this.trace = bl2;
        this.releaseImmediately = bl;
    }

    public long lockPriority() {
        return this.pInstance.lockOrder;
    }

    @Override
    public int phase() {
        return -2;
    }

    public void lock() {
        this.pInstance.lock.lock();
    }

    @Override
    public void verify(StepIdentifier stepIdentifier) throws Impossible {
        this.pInstance.testToken(this.token);
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        if (this.releaseImmediately) {
            if (this.trace) {
                SimulatorEventLogger.log(stepIdentifier, (SimulationEvent)new QuicklyTesting(this.token, this.pInstance), this.pInstance);
            }
            this.pInstance.untestToken(this.token);
        } else if (this.trace) {
            SimulatorEventLogger.log(stepIdentifier, (SimulationEvent)new Testing(this.token, this.pInstance), this.pInstance);
        }
    }

    @Override
    public void rollback() {
        this.pInstance.untestToken(this.token);
    }

    public void unlock() {
        this.pInstance.lock.unlock();
    }
}

