/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.Value;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IntegerRangeSet
extends AbstractSet<Value> {
    private final int first;
    private final int last;

    public IntegerRangeSet(int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("(lower bound)" + n + " > " + n2 + " (upper  bound).");
        }
        this.first = n;
        this.last = n2;
    }

    @Override
    public int size() {
        return this.last - this.first + 1;
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof Value) {
            Value value = (Value)object;
            if (value.value instanceof Integer) {
                int n = value.intValue();
                return this.first <= n && n <= this.last;
            }
        }
        return false;
    }

    @Override
    public Iterator<Value> iterator() {
        return new Iterator<Value>(){
            private int next;
            private boolean hasNext;
            {
                this.next = IntegerRangeSet.this.first;
                this.hasNext = true;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Value next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = this.next != IntegerRangeSet.this.last;
                return new Value(new Integer(this.next++));
            }
        };
    }
}

