/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class Lock
implements Serializable {
    public static Logger logger = Logger.getLogger(Lock.class);
    private transient List<Throwable> lastLockTraces = new ArrayList<Throwable>();
    private transient Thread lockingThread = null;
    private transient int lockCount = 0;

    public synchronized void lock() {
        Thread thread = Thread.currentThread();
        while (this.lockingThread != null && !this.mayLock(this.lockingThread)) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)new LockDebugLogEvent("Thread " + Thread.currentThread() + " has to wait for lock.", this, this.lockCount, this.lastLockTraces, new Throwable("Waiting thread trace")));
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ++this.lockCount;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Locked " + this.toString() + " by Thread: " + thread.toString()));
        }
        if (this.lockCount == 1) {
            this.lockingThread = thread;
        }
        if (logger.isDebugEnabled()) {
            this.lastLockTraces.add(new Throwable("Locking thread trace no. " + this.lockCount));
        }
    }

    public synchronized void unlock() {
        this.verify();
        --this.lockCount;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Unlocked " + this.toString() + " by Thread: " + Thread.currentThread().toString()));
        }
        if (this.lockCount == 0) {
            this.lockingThread = null;
            this.lastLockTraces.clear();
        }
        this.notify();
    }

    public synchronized void verify() {
        if (!this.mayLock(this.lockingThread)) {
            if (this.lockingThread == null) {
                throw new IllegalStateException("The lock is not locked.");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)new LockDebugLogEvent("The lock was locked by another thread.", this, this.lockCount, this.lastLockTraces, new Throwable("Wrong unlocking thread trace")));
            }
            throw new IllegalStateException("The lock was locked by another thread (" + this.lockingThread + ",hc=" + this.lockingThread.hashCode() + " instead of " + Thread.currentThread() + ",hc=" + Thread.currentThread().hashCode() + ").");
        }
    }

    protected boolean mayLock(Thread thread) {
        return Thread.currentThread() == thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Lock lock = this;
        synchronized (lock) {
            if (this.lockCount != 0 || this.lockingThread != null) {
                throw new NotSerializableException("de.renew.util.Lock: " + this + " is in use.");
            }
            objectOutputStream.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.lockCount = 0;
        this.lockingThread = null;
        this.lastLockTraces = new ArrayList<Throwable>();
    }

    private static class LockDebugLogEvent {
        private final String situation;
        private final Lock lock;
        private final int lockCount;
        private final List<Throwable> lastLockTraces;
        private final Throwable currentTrace;

        public LockDebugLogEvent(String string, Lock lock, int n, List<Throwable> list, Throwable throwable) {
            this.situation = string;
            this.lock = lock;
            this.lockCount = n;
            this.lastLockTraces = new ArrayList<Throwable>(list);
            this.currentTrace = throwable;
        }

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println(this.situation);
            printWriter.println("Lock: " + this.lock);
            printWriter.println("Current lock count: " + this.lockCount);
            this.currentTrace.printStackTrace(printWriter);
            for (Throwable throwable : this.lastLockTraces) {
                if (throwable == null) continue;
                throwable.printStackTrace(printWriter);
            }
            return stringWriter.toString();
        }
    }
}

