/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.ClassSource;
import de.renew.util.DelayedField;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;

public class RenewObjectInputStream
extends ObjectInputStream {
    private final boolean copiousBehaviour;

    public RenewObjectInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
        this(inputStream, false);
    }

    public RenewObjectInputStream(InputStream inputStream, boolean bl) throws IOException, StreamCorruptedException {
        super(inputStream);
        this.copiousBehaviour = bl;
    }

    public boolean isCopiousBehaviour() {
        return this.copiousBehaviour;
    }

    public void readDelayedObjects() throws IOException, ClassNotFoundException {
        if (super.readObject().equals("Delayed:")) {
            int n = super.readInt();
            while (n > 0) {
                for (int i = 1; i <= n; ++i) {
                    DelayedField delayedField = (DelayedField)ClassSource.readObject(this);
                    delayedField.reassign();
                }
                n = super.readInt();
            }
        } else {
            throw new StreamCorruptedException("Stream did not contain expected delayed object section label.");
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.readDelayedObjects();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StreamCorruptedException("Exception occured while reading delayed objects on close: " + classNotFoundException);
        }
        catch (IOException iOException) {
            throw new StreamCorruptedException("Exception occured while reading delayed objects on close: " + iOException);
        }
        finally {
            super.close();
        }
    }
}

