/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.SchedulerPair;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Scheduler
implements Runnable {
    private static Logger logger = Logger.getLogger(Scheduler.class);
    private static Scheduler instance;
    private Thread schedulerThread = null;
    private TreeMap<Long, SchedulerPair> queues = new TreeMap();

    private Scheduler() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this + ": created instance."));
        }
    }

    public static synchronized Scheduler instance() {
        if (instance == null) {
            instance = new Scheduler();
        }
        return instance;
    }

    private void ensureRunningThread() {
        if (this.schedulerThread == null) {
            this.schedulerThread = new Thread((Runnable)this, "Renew Scheduler");
            this.schedulerThread.start();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this + ": created thread."));
            }
        }
    }

    private SchedulerPair takeEarliest() {
        if (this.queues.isEmpty()) {
            return null;
        }
        Long l = this.queues.firstKey();
        return this.queues.remove(l);
    }

    private SchedulerPair takePairAt(long l) {
        Long l2 = new Long(l);
        SchedulerPair schedulerPair = this.queues.remove(l2);
        return schedulerPair == null ? new SchedulerPair(l2) : schedulerPair;
    }

    private void putPair(SchedulerPair schedulerPair) {
        if (!schedulerPair.list.isEmpty()) {
            this.queues.put(schedulerPair.key, schedulerPair);
        }
    }

    public synchronized void executeIn(Runnable runnable, long l) {
        this.executeAt(runnable, System.currentTimeMillis() + l);
    }

    public synchronized void executeAt(Runnable runnable, long l) {
        SchedulerPair schedulerPair = this.takePairAt(l);
        schedulerPair.list.addFirst(runnable);
        this.putPair(schedulerPair);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this + ": scheduled " + runnable + " for " + l));
        }
        this.ensureRunningThread();
        this.notifyAll();
    }

    public synchronized void cancel(Runnable runnable) {
        Object object;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this + ": request to cancel " + runnable));
        }
        Iterator<SchedulerPair> iterator = this.queues.values().iterator();
        Vector<Long> vector = new Vector<Long>(this.queues.size());
        while (iterator.hasNext()) {
            object = iterator.next();
            ((SchedulerPair)object).list.remove(runnable);
            if (!((SchedulerPair)object).list.isEmpty()) continue;
            vector.add(((SchedulerPair)object).key);
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            this.queues.remove(object.nextElement());
        }
        this.notifyAll();
    }

    @Override
    public synchronized void run() {
        SchedulerPair schedulerPair;
        do {
            long l;
            if ((schedulerPair = this.takeEarliest()) == null) continue;
            long l2 = schedulerPair.key;
            if (l2 > (l = System.currentTimeMillis())) {
                this.putPair(schedulerPair);
                try {
                    this.wait(l2 - l);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            while (!schedulerPair.list.isEmpty()) {
                Runnable runnable = schedulerPair.list.removeLast();
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)(this + ": executing at " + l + ": " + runnable));
                }
                runnable.run();
            }
        } while (schedulerPair != null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this + ": quitting thread."));
        }
        this.schedulerThread = null;
    }
}

