/*
 * Decompiled with CFR 0.152.
 */
package de.renew.io.exportFormats;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.ExportHolderImpl;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.exportFormats.ExportFormat;
import CH.ifa.draw.util.Iconkit;
import de.renew.io.exportFormats.EPSExportFormat;
import de.renew.plugin.command.CLCommand;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.PrintStream;
import org.apache.log4j.Logger;

public class ExportClCommand
implements CLCommand,
StatusDisplayer {
    private static final String SYNOPSIS = "Exports a drawing. Usage: ex <type> [drawing]+";
    private static Logger logger = Logger.getLogger(ExportClCommand.class);

    /*
     * WARNING - void declaration
     */
    public void execute(String[] stringArray, PrintStream printStream) {
        int n;
        if (Iconkit.instance() == null) {
            new Iconkit((Component)new Frame());
        }
        ExportHolderImpl exportHolderImpl = (ExportHolderImpl)DrawPlugin.getCurrent().getExportHolder();
        ExportFormat[] exportFormatArray = exportHolderImpl.allExportFormats();
        if (stringArray.length == 0) {
            printStream.append("Exports a drawing. Usage: ex <type> [drawing]+\n");
            printStream.append("List of available formats:\n");
            ExportFormat[] object2 = exportFormatArray;
            int n2 = object2.length;
            for (n = 0; n < n2; ++n) {
                ExportFormat exportFormat = object2[n];
                printStream.append(ExportClCommand.class.getSimpleName() + ": " + exportFormat + "\n");
            }
        }
        if (stringArray.length >= 2) {
            String string = stringArray[0];
            EPSExportFormat ePSExportFormat = new EPSExportFormat();
            for (n = 0; n < exportFormatArray.length; ++n) {
                logger.debug((Object)exportFormatArray[n]);
                String string2 = exportFormatArray[n].formatName().toLowerCase();
                if (!string2.equals(string.toLowerCase())) continue;
                ePSExportFormat = exportFormatArray[n];
                logger.info((Object)(ExportClCommand.class.getName() + ": format is " + ePSExportFormat.formatName()));
                if (!(ePSExportFormat.fileFilter() instanceof SimpleFileFilter)) break;
                String string3 = ((SimpleFileFilter)ePSExportFormat.fileFilter()).getExtension();
                break;
            }
            for (n = 1; n < stringArray.length; ++n) {
                void var5_8;
                String string4 = stringArray[n];
                logger.info((Object)(ExportClCommand.class.getName() + ": filename is " + string4));
                File file = new File(string4);
                if (!file.exists()) continue;
                Drawing drawing = DrawingFileHelper.loadDrawing((File)file, (StatusDisplayer)this);
                logger.info((Object)(ExportClCommand.class.getName() + ": drawing is " + drawing.getName()));
                File file2 = new File(drawing.getFilename().getAbsoluteFile().getParentFile(), drawing.getName() + "." + (String)var5_8);
                logger.info((Object)(ExportClCommand.class.getName() + ": path is " + file2));
                exportHolderImpl.saveDrawing(drawing, (ExportFormat)ePSExportFormat, file2, (StatusDisplayer)this);
            }
        }
    }

    public String getDescription() {
        return "Exports a drawing. Usage: ex <type> [drawing]+ Type ex for a list of supported formats. ";
    }

    public void showStatus(String string) {
        logger.info((Object)(ExportClCommand.class.getName() + " Status: " + string));
    }
}

