/*
 * Decompiled with CFR 0.152.
 */
package de.renew.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Mkdir;
import org.apache.tools.ant.taskdefs.Replace;
import org.apache.tools.ant.taskdefs.optional.javacc.JavaCC;
import org.apache.tools.ant.types.FileSet;

public class EnhancedJavaCCTask
extends Task {
    private File javacchome;
    private File destdir;
    private FileSet fileset;
    private File srcbase;
    private String jdkversion;

    public void init() throws BuildException {
        super.init();
    }

    public void setDestdir(File file) {
        this.destdir = file;
    }

    public void setJavacchome(File file) {
        this.javacchome = file;
    }

    public void addConfiguredFileset(FileSet fileSet) {
        this.fileset = fileSet;
        this.srcbase = fileSet.getDir(this.getProject());
    }

    public void setSrcbase(File file) {
        this.srcbase = file;
    }

    public void setJDKversion(String string) {
        this.jdkversion = string;
    }

    public void execute() throws BuildException {
        DirectoryScanner directoryScanner = this.fileset.getDirectoryScanner(this.getProject());
        String[] stringArray = directoryScanner.getIncludedFiles();
        File file = directoryScanner.getBasedir();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file.getAbsolutePath() + File.separator + stringArray[i]);
            if (!file2.isFile()) {
                throw new BuildException("javacc-File " + file2 + " does not exist!");
            }
            this.executeJavaCC(file2);
        }
    }

    private void executeJavaCC(File file) throws BuildException {
        Mkdir mkdir;
        File file2 = file;
        String string = file.getParent();
        String string2 = string.substring(this.srcbase.getAbsolutePath().length());
        File file3 = new File(this.destdir.getAbsolutePath() + File.separator + string2);
        if (!file3.isDirectory()) {
            mkdir = (Mkdir)this.getProject().createTask("mkdir");
            mkdir.setDir(file3);
            mkdir.init();
            mkdir.execute();
        }
        mkdir = (JavaCC)this.getProject().createTask("javacc");
        mkdir.setJavacchome(this.javacchome);
        mkdir.setTarget(file2);
        mkdir.setOutputdirectory(file3);
        if (this.jdkversion != null) {
            mkdir.setJDKversion(this.jdkversion);
        }
        mkdir.init();
        mkdir.execute();
        String string3 = file.getName();
        if (string3 == null || !string3.endsWith(".jj")) {
            this.log("Cannot determine filename of token manager to add @SuppressWarnings. Skipping this step.", 1);
        } else {
            String string4 = string3.substring(0, string3.length() - 3) + "TokenManager.java";
            File file4 = new File(file3, string4);
            this.log("Trying to insert @SuppressWarnings(\"unused\") in " + file4, 3);
            Replace replace = (Replace)this.getProject().createTask("replace");
            replace.setFile(file4);
            Replace.NestedString nestedString = replace.createReplaceToken();
            nestedString.addText("/** Token Manager. */\npublic class");
            Replace.NestedString nestedString2 = replace.createReplaceValue();
            nestedString2.addText("/** Token Manager. */\n@SuppressWarnings(\"unused\")\npublic class");
            replace.execute();
        }
    }
}

