/*
 * Decompiled with CFR 0.152.
 */
package de.renew.watch;

import de.renew.engine.common.StepIdentifier;
import de.renew.engine.searcher.ChannelTarget;
import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.TriggerCollection;
import de.renew.engine.searcher.Triggerable;
import de.renew.engine.simulator.ExecuteFinder;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.NetInstance;
import de.renew.unify.Impossible;
import de.renew.unify.Tuple;
import de.renew.unify.Variable;
import de.renew.util.DelayedFieldOwner;
import de.renew.util.EmptyIterator;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import de.renew.util.Semaphor;
import de.renew.watch.ChannelWatcher;
import de.renew.watch.ParamFinder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class ChannelSupervisor
implements Triggerable,
Serializable,
DelayedFieldOwner {
    public static Logger logger = Logger.getLogger(ChannelSupervisor.class);
    static final long serialVersionUID = 8023504578713732407L;
    private static LinkedList<ChannelSupervisor> dirtySupervisors = new LinkedList();
    private static List<ChannelSupervisor> allSupervisors = Collections.synchronizedList(new LinkedList());
    private static Semaphor dirtySem = new Semaphor();
    private static SupervisorThread supervisorThread;
    private final transient NetInstance netInstance;
    private final transient ChannelWatcher watcher;
    private final transient String channel;
    private final transient Class<?> lateClass;
    private TriggerCollection triggers;
    private transient boolean valid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelSupervisor(NetInstance netInstance, ChannelWatcher channelWatcher, String string, Class<?> clazz) {
        this.netInstance = netInstance;
        this.watcher = channelWatcher;
        this.channel = string;
        this.lateClass = clazz;
        this.valid = true;
        this.triggers = new TriggerCollection((Triggerable)this);
        List<ChannelSupervisor> list = allSupervisors;
        synchronized (list) {
            allSupervisors.add(0, this);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("New " + this.toString() + "."));
        }
        this.proposeSearch();
    }

    public boolean execute(final Object object, final Object object2, final StepIdentifier stepIdentifier) {
        block5: {
            if (this.valid) {
                Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        ExecuteFinder executeFinder = new ExecuteFinder();
                        Tuple tuple = new Tuple(new Object[]{object, object2}, null);
                        Variable variable = new Variable((Object)tuple, null);
                        Searcher searcher = new Searcher();
                        searcher.initiatedSearch((ChannelTarget)ChannelSupervisor.this.netInstance, ChannelSupervisor.this.channel, variable, false, (Finder)executeFinder, null);
                        boolean bl = executeFinder.isCompleted();
                        if (bl) {
                            executeFinder.execute(stepIdentifier, true);
                        }
                        return bl;
                    }
                });
                try {
                    return (Boolean)future.get();
                }
                catch (InterruptedException interruptedException) {
                    logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
                    break block5;
                }
                catch (ExecutionException executionException) {
                    logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
                    break block5;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Call to execute on invalid ChannelSupervisor:" + this.toString() + ", parameters: early=" + object + ", late=" + object2 + ", step=" + stepIdentifier), new Throwable("DEBUG STACKTRACE"));
            }
        }
        return false;
    }

    public TriggerCollection triggers() {
        return this.triggers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proposeSearch() {
        if (this.valid) {
            List<ChannelSupervisor> list = allSupervisors;
            synchronized (list) {
                dirtySupervisors.addLast(this);
                this.triggers.clear();
            }
            dirtySem.V();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Call to proposeSearch on invalid ChannelSupervisor:" + this.toString() + ". Clearing trigger collection."));
            }
            this.triggers.clear();
        }
    }

    void update() {
        if (this.valid) {
            final ChannelSupervisor channelSupervisor = this;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Initiating update on " + this.toString() + "..."));
            }
            Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object call() throws Exception {
                    Tuple tuple = new Tuple(2);
                    Variable variable = new Variable(tuple.getComponent(0), null);
                    Searcher searcher = new Searcher();
                    try {
                        searcher.calcChecker.addEarlyVariable(variable, null);
                        searcher.calcChecker.addCalculated(ChannelSupervisor.this.lateClass, tuple.getComponent(1), null, null);
                    }
                    catch (Impossible impossible) {
                        throw new RuntimeException("Error in unification algorithm.");
                    }
                    ParamFinder paramFinder = new ParamFinder(variable);
                    searcher.initiatedSearch((ChannelTarget)ChannelSupervisor.this.netInstance, ChannelSupervisor.this.channel, new Variable((Object)tuple, null), false, (Finder)paramFinder, (Triggerable)channelSupervisor);
                    2 var5_6 = this;
                    synchronized (var5_6) {
                        if (ChannelSupervisor.this.watcher != null) {
                            ChannelSupervisor.this.watcher.bindingsCalculated(paramFinder.iterator());
                        }
                    }
                    return null;
                }
            });
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
                logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
            }
            catch (ExecutionException executionException) {
                logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Call to update on invalid ChannelSupervisor:" + this.toString()), new Throwable("DEBUG STACKTRACE"));
        }
    }

    private synchronized void discard() {
        if (this.watcher != null) {
            this.watcher.bindingsCalculated((Iterator<Object>)EmptyIterator.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        List<ChannelSupervisor> list = allSupervisors;
        synchronized (list) {
            logger.debug((Object)"Resetting all ChannelSupervisors.");
            dirtySupervisors.clear();
            for (ChannelSupervisor channelSupervisor : allSupervisors) {
                channelSupervisor.discard();
            }
            allSupervisors.clear();
            if (supervisorThread != null) {
                supervisorThread.terminate();
                supervisorThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activate() {
        List<ChannelSupervisor> list = allSupervisors;
        synchronized (list) {
            ChannelSupervisor.reset();
            logger.debug((Object)"Activating new ChannelSupervisor thread.");
            if (supervisorThread == null) {
                supervisorThread = new SupervisorThread();
                SimulationThreadPool.getCurrent().execute((Runnable)supervisorThread);
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RenewObjectOutputStream renewObjectOutputStream = null;
        if (objectOutputStream instanceof RenewObjectOutputStream) {
            renewObjectOutputStream = (RenewObjectOutputStream)objectOutputStream;
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.beginDomain((Object)this);
        }
        objectOutputStream.defaultWriteObject();
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.delayedWriteObject((Object)this.triggers, (DelayedFieldOwner)this);
            renewObjectOutputStream.endDomain((Object)this);
        } else {
            objectOutputStream.writeObject(this.triggers);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.valid = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deserializing " + this.toString() + "..."));
        }
        if (!(objectInputStream instanceof RenewObjectInputStream)) {
            this.reassignField(objectInputStream.readObject());
        }
    }

    public void reassignField(Object object) throws IOException {
        if (object instanceof TriggerCollection) {
            this.triggers = (TriggerCollection)object;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Deserialization completed:  " + this.toString()));
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("(");
        if (this.valid) {
            stringBuffer.append("valid");
            stringBuffer.append(", ");
            stringBuffer.append("netInstance=").append(this.netInstance);
            stringBuffer.append(", ");
            stringBuffer.append("watcher=").append(this.watcher);
            stringBuffer.append(", ");
            stringBuffer.append("channel=").append(this.channel);
            stringBuffer.append(", ");
            stringBuffer.append("lateClass=").append(this.lateClass);
        } else {
            stringBuffer.append("invalid");
        }
        stringBuffer.append(", ");
        stringBuffer.append("triggers=").append(this.triggers);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static class SupervisorThread
    implements Runnable {
        private boolean active = true;

        private SupervisorThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ChannelSupervisor: Thread " + Thread.currentThread() + " started."));
            }
            while (this.active) {
                ChannelSupervisor channelSupervisor;
                dirtySem.P();
                if (!this.active) {
                    dirtySem.V();
                    continue;
                }
                List list = allSupervisors;
                synchronized (list) {
                    channelSupervisor = (ChannelSupervisor)dirtySupervisors.getFirst();
                    dirtySupervisors.removeFirst();
                }
                channelSupervisor.update();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ChannelSupervisor: Thread " + Thread.currentThread() + " terminated."));
            }
        }

        public void terminate() {
            logger.debug((Object)"ChannelSupervisor: Thread marked for termination.");
            this.active = false;
        }
    }
}

