/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.application.SimulationEnvironment;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.remote.Server;
import de.renew.remote.SimulatorAccessor;
import de.renew.remote.SimulatorAccessorImpl;
import de.renew.remote.SocketFactoryDeterminer;
import java.net.MalformedURLException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class ServerImpl
extends UnicastRemoteObject
implements Server {
    public static Logger logger = Logger.getLogger(ServerImpl.class);
    private SimulationEnvironment environment = null;

    public ServerImpl(SimulationEnvironment simulationEnvironment) throws RemoteException {
        super(0, SocketFactoryDeterminer.getInstance(), SocketFactoryDeterminer.getInstance());
        this.environment = simulationEnvironment;
    }

    @Override
    public SimulatorAccessor getSimulator() throws RemoteException {
        return new SimulatorAccessorImpl(this.environment);
    }

    public static String bindServer(final Server server, final String string, final boolean bl) {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String string2;
                block6: {
                    string2 = ServerImpl.makeLocalServerUrl(string);
                    try {
                        try {
                            logger.debug((Object)("ServerImpl: Binding server to URL " + string2 + "..."));
                            Naming.bind(string2, server);
                            logger.debug((Object)("ServerImpl: Bound to " + string2 + "."));
                        }
                        catch (AlreadyBoundException alreadyBoundException) {
                            if (bl) {
                                logger.debug((Object)("ServerImpl: " + string2 + " already in use. Rebinding ..."));
                                Naming.rebind(string2, server);
                                break block6;
                            }
                            logger.error((Object)("ServerImpl: " + string2 + " already in use. Aborting."));
                            string2 = null;
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        logger.error((Object)("ServerImpl: " + string2 + " is a malformed URL. Aborting."));
                        string2 = null;
                    }
                    catch (RemoteException remoteException) {
                        logger.warn((Object)("ServerImpl: Could not bind server to " + string2 + ": " + remoteException));
                        string2 = null;
                    }
                }
                return string2;
            }
        });
        try {
            return (String)future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }

    public static void unbindServer(String string) {
        try {
            logger.debug((Object)("ServerImpl: Unbinding server from URL " + string + "..."));
            Naming.unbind(string);
            logger.debug((Object)("ServerImpl: Unbound from " + string + "."));
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)("ServerImpl: " + string + " is a malformed URL. Unbinding failed."));
        }
        catch (NotBoundException notBoundException) {
            logger.error((Object)("ServerImpl: " + string + " was not bound. Unbinding failed."));
        }
        catch (RemoteException remoteException) {
            logger.error((Object)("ServerImpl: Unbinding from " + string + " failed: " + remoteException));
        }
    }

    public static synchronized Server getInstance(String string) throws RemoteException, NotBoundException {
        return ServerImpl.getInstance(string, "default");
    }

    public static synchronized Server getInstance(String string, String string2) throws RemoteException, NotBoundException {
        try {
            return (Server)Naming.lookup(ServerImpl.makeServerUrl(string, string2));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException("An internal error occurred: " + malformedURLException);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(string + ":" + string2 + " is not a renew server");
        }
    }

    public static String makeLocalServerUrl(String string) {
        return ServerImpl.makeServerUrl("localhost", string);
    }

    public static String makeServerUrl(String string) {
        return ServerImpl.makeServerUrl(string, null);
    }

    public static String makeServerUrl(String string, String string2) {
        return "//" + string + "/" + Server.class.getName() + "." + (string2 == null ? "default" : string2);
    }
}

