/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.PlaceInstance;
import de.renew.remote.SocketFactoryDeterminer;
import de.renew.remote.TokenCountsAccessor;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class TokenCountsAccessorImpl
extends UnicastRemoteObject
implements TokenCountsAccessor {
    public static Logger logger = Logger.getLogger(TokenCountsAccessorImpl.class);
    private int freeTokenCount;
    private int testedTokenCount;

    public TokenCountsAccessorImpl(final PlaceInstance placeInstance) throws RemoteException {
        super(0, SocketFactoryDeterminer.getInstance(), SocketFactoryDeterminer.getInstance());
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                placeInstance.lock.lock();
                try {
                    TokenCountsAccessorImpl.this.freeTokenCount = placeInstance.getNumberOfTokens();
                    TokenCountsAccessorImpl.this.testedTokenCount = placeInstance.getNumberOfTestedTokens();
                }
                finally {
                    placeInstance.lock.unlock();
                }
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
    }

    @Override
    public int getFreeTokenCount() throws RemoteException {
        return this.freeTokenCount;
    }

    @Override
    public int getTestedTokenCount() throws RemoteException {
        return this.testedTokenCount;
    }

    @Override
    public boolean isEmpty() throws RemoteException {
        return this.freeTokenCount + this.testedTokenCount <= 0;
    }
}

