/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.IOHelper;
import CH.ifa.draw.application.DrawingLoadServer;
import CH.ifa.draw.application.DrawingMenuListener;
import CH.ifa.draw.application.DrawingViewContainer;
import CH.ifa.draw.application.DrawingViewContainerSupplier;
import CH.ifa.draw.application.DrawingViewFrame;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.application.NewDrawingDialog;
import CH.ifa.draw.application.WindowsMenu;
import CH.ifa.draw.contrib.DiamondFigure;
import CH.ifa.draw.contrib.PolygonTool;
import CH.ifa.draw.contrib.TriangleFigure;
import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.ElbowConnection;
import CH.ifa.draw.figures.EllipseFigure;
import CH.ifa.draw.figures.ImageFigureCreationTool;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.LineFigure;
import CH.ifa.draw.figures.PieFigure;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.figures.RoundRectangleFigure;
import CH.ifa.draw.figures.ScribbleTool;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.figures.TextTool;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingTypeManager;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.framework.UndoRedoManager;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.PositionedDrawing;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.standard.ConnectionTool;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.FigureException;
import CH.ifa.draw.standard.NullDrawingView;
import CH.ifa.draw.standard.SelectionTool;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.AutosaveManager;
import CH.ifa.draw.util.AutosaveSaver;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.DrawingListener;
import CH.ifa.draw.util.DynamicFlowLayout;
import CH.ifa.draw.util.Fontkit;
import CH.ifa.draw.util.GUIProperties;
import CH.ifa.draw.util.HotDrawFocusManager;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.Palette;
import CH.ifa.draw.util.PaletteListener;
import de.renew.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import javax.swing.RootPaneContainer;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class DrawApplication
implements DrawingEditor,
PaletteListener,
StatusDisplayer,
AutosaveSaver {
    public static Logger logger = Logger.getLogger(DrawApplication.class);
    private static int windowCount = 0;
    private static final String fgDrawPath = "/CH/ifa/draw/";
    public static final String IMAGES = "/CH/ifa/draw/images/";
    public static final int FILE_MENU = 0;
    public static final int EDIT_MENU = 1;
    public static final int LAYOUT_MENU = 2;
    public static final int ATTRIBUTES_MENU = 3;
    public static final int DRAWINGS_MENU = 4;
    private static final int AUTOSAVE_INTERVAL = 120000;
    protected JFrame menuFrame;
    protected JFrame toolFrame;
    private JPanel toolPanel;
    static Font fMenuFont;
    private Vector<Drawing> fDrawings = new Vector();
    private Tool fTool;
    private Iconkit fIconkit;
    private JTextField fStatusLine;
    protected Vector<DrawingViewContainer> fViewContainers = new Vector();
    protected DrawingViewContainer fViewContainer;
    private boolean fToolButtonSticky = false;
    private boolean fAlwaysSticky = false;
    private ToolButton fDefaultToolButton;
    private ToolButton fSelectedToolButton = null;
    private ToolButton fConnTextTB;
    private ToolButton fTextTB;
    protected DrawingViewContainerSupplier dvContainerSupplier;
    private AutosaveManager autosaveManager = new AutosaveManager(this, 120000L);
    private UndoRedoManager undoManager = new UndoRedoManager(this);
    private Vector<DrawingListener> drawingListeners;

    public DrawApplication() {
        this("JHotDraw");
    }

    public DrawApplication(String string) {
        this(string, new String[0]);
    }

    public DrawApplication(String string, String[] stringArray) {
        this(string, null, null, stringArray, null);
    }

    public DrawApplication(String string, String string2, SimpleFileFilter simpleFileFilter, String[] stringArray, String string3) {
        Object object;
        Object object2;
        DrawPlugin.setGui(this);
        this.drawingListeners = new Vector();
        this.dvContainerSupplier = new DefaultDrawingViewContainerSupplier();
        if (simpleFileFilter != null) {
            object2 = DrawingTypeManager.getInstance();
            ((DrawingTypeManager)object2).register(string2, simpleFileFilter);
            ((DrawingTypeManager)object2).setDefaultFileFilter(simpleFileFilter);
        }
        object2 = null;
        int n = GUIProperties.loadServerPort();
        if (n != -1) {
            try {
                object2 = new DrawingLoadServer(this, n);
            }
            catch (IOException iOException) {
                logger.error((Object)"Server Socket is occupied!");
            }
        }
        this.menuFrame = new JFrame(string);
        this.fStatusLine = this.createStatusLine();
        this.menuFrame.getContentPane().add(this.wrapStatusLine(this.fStatusLine), "South");
        this.toolFrame = this.menuFrame;
        this.fIconkit = new Iconkit(this.toolFrame);
        if (string3 != null) {
            object = this.fIconkit.loadImageResource(string3);
            if (object == null) {
                logger.error((Object)("Resource icon " + string3 + " could not be loaded!"));
            } else {
                this.menuFrame.setIconImage((Image)object);
            }
        }
        this.toolPanel = new JPanel();
        this.toolPanel.setBackground(Color.lightGray);
        this.toolPanel.setLayout(new DynamicFlowLayout(0, 2, 0));
        this.toolFrame.getContentPane().add((Component)this.toolPanel, "Center");
        this.createTools(this.toolPanel);
        object = new JMenuBar();
        fMenuFont = ((Component)object).getFont();
        int n2 = GUIProperties.menuFontSize();
        if (n2 != -1) {
            logger.debug((Object)("Setting menu font size to " + n2 + " pt."));
            fMenuFont = Fontkit.getFont("SansSerif", 0, n2);
        }
        this.menuFrame.setJMenuBar((JMenuBar)object);
        this.addListeners();
        new HotDrawFocusManager(this.menuFrame.getJMenuBar());
        this.menuFrame.pack();
        this.menuFrame.setVisible(true);
        if (this.toolFrame != this.menuFrame) {
            this.toolFrame.setVisible(true);
        }
        ++windowCount;
        this.toolDone();
        this.loadAndOpenCommandLineDrawings(stringArray);
        if (object2 != null) {
            ((Thread)object2).start();
        }
        JMenuItem jMenuItem = new JMenuItem("Menu and tools");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                JFrame jFrame = DrawApplication.this.getFrame();
                jFrame.setExtendedState(jFrame.getExtendedState() & 0xFFFFFFFE);
                jFrame.toFront();
            }
        });
        MenuManager.getInstance().registerMenu("Windows", jMenuItem, "CH.ifa.drawWindowsMenu and tools");
        MenuManager.getInstance().setGui(this);
        logger.debug((Object)"DrawApplication: started gui.");
    }

    protected Component wrapStatusLine(Component component) {
        return component;
    }

    @Override
    public Image getIconImage() {
        return this.menuFrame.getIconImage();
    }

    public JFrame getFrame() {
        return this.menuFrame;
    }

    protected void addListeners() {
        this.menuFrame.setDefaultCloseOperation(0);
        this.menuFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DrawApplication.this.requestClose();
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }
        });
        this.menuFrame.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
            }
        });
        this.menuFrame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (!GUIProperties.avoidFrameReshape()) {
                    Dimension dimension = DrawApplication.this.menuFrame.getPreferredSize();
                    Dimension dimension2 = DrawApplication.this.menuFrame.getSize();
                    DrawApplication.this.menuFrame.setSize(Math.max(dimension.width, dimension2.width), dimension.height);
                }
            }
        });
    }

    @Override
    public void dispatchEvent(KeyEvent keyEvent) {
        this.menuFrame.dispatchEvent(keyEvent);
    }

    public JPanel getToolsPanel() {
        return this.toolPanel;
    }

    public DrawingViewContainerSupplier getDrawingViewContainerSupplier() {
        return this.dvContainerSupplier;
    }

    public void setDrawingViewContainerSupplier(DrawingViewContainerSupplier drawingViewContainerSupplier) {
        this.dvContainerSupplier = drawingViewContainerSupplier;
    }

    protected DrawApplication newWindow() {
        return new DrawApplication(this.menuFrame.getTitle());
    }

    private void updateName(Drawing drawing, File file) {
        this.showDrawingViewContainer(drawing);
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            logger.error((Object)iOException);
        }
        String string = StringUtil.getFilename((String)file.getName());
        this.fViewContainer.setTitle(string);
        if (this.fViewContainer instanceof RootPaneContainer) {
            ((RootPaneContainer)((Object)this.fViewContainer)).getRootPane().putClientProperty("Window.documentFile", file);
        }
        drawing.setName(string);
        drawing.setFilename(file);
        this.getWindowsMenu().setName(drawing, string);
    }

    void addMenu(JMenu jMenu, int n) {
        this.menuFrame.getJMenuBar().add((Component)jMenu, n);
        this.menuFrame.pack();
    }

    void addMenu(JMenu jMenu) {
        this.menuFrame.getJMenuBar().add(jMenu);
        this.menuFrame.pack();
    }

    void removeMenu(JMenu jMenu) {
        this.menuFrame.getJMenuBar().remove(jMenu);
        this.menuFrame.pack();
    }

    private WindowsMenu getWindowsMenu() {
        return MenuManager.getInstance().getWindowsMenu();
    }

    public void addDrawing(Drawing drawing) {
        if (!this.fDrawings.contains(drawing)) {
            this.fDrawings.addElement(drawing);
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(drawing.getName());
            jRadioButtonMenuItem.setFont(fMenuFont);
            jRadioButtonMenuItem.addActionListener(new DrawingMenuListener(this, drawing));
            this.getWindowsMenu().addDrawing(drawing, jRadioButtonMenuItem);
            this.undoManager.newUndoHistory(drawing);
            this.drawingAdded(drawing);
        }
    }

    protected boolean closeViewContainer(DrawingViewContainer drawingViewContainer) {
        boolean bl = this.checkDrawingModifiedOnClose(drawingViewContainer);
        if (bl) {
            this.destroyViewContainer(drawingViewContainer);
        }
        return bl;
    }

    protected boolean checkDrawingModifiedOnClose(DrawingViewContainer drawingViewContainer) {
        Drawing drawing = drawingViewContainer.view().drawing();
        if (drawing.isModified()) {
            this.showDrawingViewContainer(drawing);
            Object[] objectArray = new Object[]{"Save now", "Close / Do not save", "Cancel"};
            Icon icon = null;
            int n = JOptionPane.showOptionDialog(drawingViewContainer.getFrame(), "Renew: The drawing \"" + drawing.getName() + "\"" + " you are about to close" + " has been modified." + "\n What do you want to do?", "Save drawing?", 0, 3, icon, objectArray, objectArray[0]);
            switch (n) {
                case 0: {
                    return this.saveDrawing(drawing);
                }
                case 1: {
                    break;
                }
                case 2: {
                    return false;
                }
                default: {
                    assert (false) : "JOptionPane returned unexpected result: " + n;
                    break;
                }
            }
        }
        return true;
    }

    public void destroyViewContainer(DrawingViewContainer drawingViewContainer) {
        int n;
        this.toolDone();
        Drawing drawing = drawingViewContainer.view().drawing();
        drawing.release();
        this.drawingReleased(drawing);
        drawingViewContainer.discard();
        this.fViewContainers.removeElement(drawingViewContainer);
        if (drawingViewContainer == this.fViewContainer) {
            n = this.fViewContainers.size();
            if (n > 0) {
                this.setCurrentDrawing(this.fViewContainers.elementAt(n - 1));
                this.fViewContainer.getFrame().setVisible(true);
                this.fViewContainer.getFrame().setState(0);
                this.fViewContainer.getFrame().requestFocus();
            } else {
                this.setCurrentDrawing(null);
            }
        }
        n = this.fDrawings.indexOf(drawing);
        this.fDrawings.removeElementAt(n);
        this.getWindowsMenu().removeDrawing(drawing);
        this.undoManager.removeUndoHistory(drawing);
        this.autosaveManager.removeDrawing(drawing);
    }

    private void drawingAdded(Drawing drawing) {
        Iterator<DrawingListener> iterator = this.drawingListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().drawingAdded(drawing);
        }
    }

    private void drawingReleased(Drawing drawing) {
        Iterator<DrawingListener> iterator = this.drawingListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().drawingReleased(drawing);
        }
    }

    public void addDrawingListener(DrawingListener drawingListener) {
        this.drawingListeners.add(drawingListener);
    }

    public static Font getMenuFont() {
        return fMenuFont;
    }

    public static JMenuItem createMenuItem(String string, int n, ActionListener actionListener) {
        JMenuItem jMenuItem;
        if (n == 0) {
            jMenuItem = new JMenuItem(string);
        } else {
            jMenuItem = new JMenuItem(string, n);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
        jMenuItem.setFont(fMenuFont);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    public static JMenuItem createMenuItem(String string, ActionListener actionListener) {
        return DrawApplication.createMenuItem(string, 0, actionListener);
    }

    public static CommandMenu createCommandMenu(String string) {
        CommandMenu commandMenu = new CommandMenu(string);
        commandMenu.setFont(fMenuFont);
        return commandMenu;
    }

    public Enumeration<Drawing> drawings() {
        return new Vector<Drawing>(this.fDrawings).elements();
    }

    public DrawingViewContainer newDrawingViewContainer(Drawing drawing) {
        return this.newDrawingViewContainer(drawing, null, null);
    }

    public DrawingViewContainer newDrawingViewContainer(Drawing drawing, Point point, Dimension dimension) {
        logger.debug((Object)"DrawApplication: newDrawingViewContainer!!!");
        Dimension dimension2 = drawing.defaultSize();
        StandardDrawingView standardDrawingView = this.createDrawingView(dimension2.width, dimension2.height);
        this.addDrawing(drawing);
        DrawingViewContainer drawingViewContainer = this.dvContainerSupplier.getContainer(this, standardDrawingView, drawing, point, dimension);
        if (drawingViewContainer instanceof RootPaneContainer && drawing.getFilename() != null) {
            ((RootPaneContainer)((Object)drawingViewContainer)).getRootPane().putClientProperty("Window.documentFile", drawing.getFilename());
        }
        this.fViewContainers.addElement(drawingViewContainer);
        this.setCurrentDrawing(drawingViewContainer);
        return drawingViewContainer;
    }

    protected void createTools(JPanel jPanel) {
        Palette palette = new Palette("Drawing Tools");
        Tool tool = this.createSelectionTool();
        this.fDefaultToolButton = this.createToolButton("/CH/ifa/draw/images/SEL", "Selection Tool", tool);
        palette.add(this.fDefaultToolButton);
        tool = new CreationTool(this, new RectangleFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/RECT", "Rectangle Tool", tool));
        tool = new CreationTool(this, new RoundRectangleFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/RRECT", "Round Rectangle Tool", tool));
        tool = new CreationTool(this, new EllipseFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/ELLIPSE", "Ellipse Tool", tool));
        tool = new CreationTool(this, new PieFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/PIE", "Elliptical Arc/Pie Tool", tool));
        tool = new CreationTool(this, new DiamondFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/DIAMOND", "Diamond Tool", tool));
        tool = new CreationTool(this, new TriangleFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/TRIANGLE", "Triangle Tool", tool));
        tool = new CreationTool(this, new LineFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/LINE", "Line Tool", tool));
        tool = new ConnectionTool(this, new LineConnection());
        palette.add(this.createToolButton("/CH/ifa/draw/images/CONN", "Connection Tool", tool));
        tool = new ConnectionTool(this, new ElbowConnection());
        palette.add(this.createToolButton("/CH/ifa/draw/images/OCONN", "Elbow Connection Tool", tool));
        tool = new ScribbleTool(this);
        palette.add(this.createToolButton("/CH/ifa/draw/images/SCRIBBL", "Scribble Tool", tool));
        tool = new PolygonTool(this);
        palette.add(this.createToolButton("/CH/ifa/draw/images/POLYGON", "Polygon Tool", tool));
        tool = new ImageFigureCreationTool((DrawingEditor)this, this.menuFrame);
        palette.add(this.createToolButton("/CH/ifa/draw/images/IMAGE", "Image Tool", tool));
        TextFigure textFigure = new TextFigure(false);
        textFigure.setAlignment(0);
        tool = new TextTool((DrawingEditor)this, textFigure);
        this.fTextTB = this.createToolButton("/CH/ifa/draw/images/TEXT", "Text Tool", tool);
        palette.add(this.fTextTB);
        textFigure = new TextFigure();
        textFigure.setAlignment(1);
        tool = new ConnectedTextTool((DrawingEditor)this, textFigure);
        this.fConnTextTB = this.createToolButton("/CH/ifa/draw/images/ATEXT", "Connected Text Tool", tool);
        palette.add(this.fConnTextTB);
        jPanel.add(palette.getComponent());
    }

    protected Tool createSelectionTool() {
        return new SelectionTool(this);
    }

    public ToolButton createToolButton(String string, String string2, Tool tool) {
        return new ToolButton(this, string, string2, tool);
    }

    protected StandardDrawingView createDrawingView(int n, int n2) {
        return new StandardDrawingView(this, n, n2);
    }

    public void unsetCurrentDrawing() {
        if (this.fViewContainer != null) {
            this.getWindowsMenu().deactivate(this.drawing());
            this.fViewContainer = null;
        }
    }

    @Override
    public void setCurrentDrawing(DrawingViewContainer drawingViewContainer) {
        if (drawingViewContainer == null) {
            this.unsetCurrentDrawing();
        } else if (this.fViewContainer != drawingViewContainer) {
            Drawing drawing = drawingViewContainer.view().drawing();
            logger.debug((Object)("Trying to activate drawing " + drawing.getName()));
            int n = this.fDrawings.indexOf(drawing);
            if (n >= 0 && this.fViewContainers.removeElement(drawingViewContainer)) {
                this.fViewContainers.addElement(drawingViewContainer);
                this.unsetCurrentDrawing();
                this.fViewContainer = drawingViewContainer;
                this.getWindowsMenu().activate(drawing);
                this.recheckMenus();
                this.menuStateChanged();
            }
        }
    }

    public void recheckMenus() {
        logger.debug((Object)"rechecking menu states...");
        JMenuBar jMenuBar = this.getFrame().getJMenuBar();
        int n = jMenuBar.getMenuCount();
        for (int i = 0; i < n; ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            if (!(jMenu instanceof CommandMenu)) continue;
            ((CommandMenu)jMenu).checkEnabled();
        }
    }

    public DrawingViewContainer getViewContainer(Drawing drawing) {
        Enumeration<DrawingViewContainer> enumeration = this.fViewContainers.elements();
        while (enumeration.hasMoreElements()) {
            DrawingViewContainer drawingViewContainer = enumeration.nextElement();
            if (drawingViewContainer.view().drawing() != drawing) continue;
            return drawingViewContainer;
        }
        return null;
    }

    public DrawingView getView(Drawing drawing) {
        DrawingViewContainer drawingViewContainer = this.getViewContainer(drawing);
        if (drawingViewContainer != null) {
            return drawingViewContainer.view();
        }
        return null;
    }

    public DrawingViewContainer showDrawingViewContainer(Drawing drawing) {
        return this.showDrawingViewContainer(drawing, null, null);
    }

    public DrawingViewContainer showDrawingViewContainer(Drawing drawing, Point point, Dimension dimension) {
        DrawingViewContainer drawingViewContainer = this.getViewContainer(drawing);
        if (drawingViewContainer != null) {
            this.setCurrentDrawing(drawingViewContainer);
            if (DrawPlugin.getCurrent().getProperties().getBoolProperty("ch.ifa.draw.window-focus-workaround")) {
                drawingViewContainer.getFrame().setVisible(false);
            }
            drawingViewContainer.getFrame().setVisible(true);
            drawingViewContainer.getFrame().setState(0);
            drawingViewContainer.getFrame().requestFocus();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(DrawApplication.class.getSimpleName() + ": " + drawingViewContainer.getFrame().getTitle() + " requests focus."));
            }
        } else {
            drawingViewContainer = this.newDrawingViewContainer(drawing, point, dimension);
        }
        return drawingViewContainer;
    }

    public boolean closeDrawing(Drawing drawing) {
        DrawingViewContainer drawingViewContainer = this.getViewContainer(drawing);
        if (drawingViewContainer != null) {
            return this.closeViewContainer(drawingViewContainer);
        }
        return false;
    }

    protected Drawing createDrawing() {
        return new StandardDrawing();
    }

    protected JTextField createStatusLine() {
        JTextField jTextField = new JTextField("No Tool", 40);
        jTextField.setEditable(false);
        return jTextField;
    }

    @Override
    public void paletteUserSelected(ToolButton toolButton, boolean bl) {
        this.setSelected(toolButton);
        this.setTool(toolButton.tool(), toolButton.name() + toolButton.getHotkey());
        this.fToolButtonSticky = !this.fAlwaysSticky && bl || this.fAlwaysSticky && !bl;
    }

    @Override
    public void paletteUserOver(ToolButton toolButton, boolean bl) {
        if (bl) {
            this.showStatus(toolButton.name() + toolButton.getHotkey());
        } else if (this.fSelectedToolButton != null) {
            this.showStatus(this.fSelectedToolButton.name() + toolButton.getHotkey());
        }
    }

    @Override
    public Drawing drawing() {
        return this.view().drawing();
    }

    @Override
    public Tool tool() {
        return this.fTool;
    }

    @Override
    public DrawingView view() {
        DrawingViewContainer drawingViewContainer = this.fViewContainer;
        if (drawingViewContainer == null) {
            return NullDrawingView.INSTANCE;
        }
        return drawingViewContainer.view();
    }

    @Override
    public DrawingView previousView() {
        int n = this.fViewContainers.size();
        if (n >= 2) {
            return this.fViewContainers.elementAt(n - 2).view();
        }
        return null;
    }

    public void toggleAlwaysSticky() {
        this.fToolButtonSticky = this.fAlwaysSticky = !this.fAlwaysSticky;
    }

    @Override
    public boolean isStickyTools() {
        return this.fToolButtonSticky;
    }

    @Override
    public void setStickyTools(boolean bl) {
        this.fToolButtonSticky = bl;
    }

    @Override
    public Tool defaultTool() {
        return this.fDefaultToolButton.tool();
    }

    @Override
    public void toolDone() {
        if (windowCount > 0) {
            if (this.fToolButtonSticky && this.tool() != null) {
                this.tool().deactivate();
                this.tool().activate();
            } else if (this.fDefaultToolButton != null) {
                this.setTool(this.fDefaultToolButton.tool(), this.fDefaultToolButton.name());
                this.setSelected(this.fDefaultToolButton);
            }
        }
    }

    @Override
    public void selectionChanged(DrawingView drawingView) {
        this.menuStateChanged();
    }

    @Override
    public void menuStateChanged() {
        JMenuBar jMenuBar = this.menuFrame.getJMenuBar();
        CommandMenu commandMenu = (CommandMenu)jMenuBar.getMenu(0);
        commandMenu.checkEnabled();
        CommandMenu commandMenu2 = (CommandMenu)jMenuBar.getMenu(1);
        commandMenu2.checkEnabled();
        CommandMenu commandMenu3 = (CommandMenu)jMenuBar.getMenu(2);
        commandMenu3.checkEnabled();
        CommandMenu commandMenu4 = (CommandMenu)jMenuBar.getMenu(3);
        commandMenu4.checkEnabled();
    }

    @Override
    public void showStatus(final String string) {
        if (EventQueue.isDispatchThread()) {
            this.fStatusLine.setText(string);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DrawApplication.this.fStatusLine.setText(string);
                }
            });
        }
        logger.debug((Object)string);
    }

    private void showAndPrint(String string) {
        this.fStatusLine.setText(string);
        logger.info((Object)string);
    }

    private void setTool(Tool tool, String string) {
        if (this.fTool != null) {
            this.fTool.deactivate();
        }
        this.fTool = tool;
        if (this.fTool != null) {
            this.fStatusLine.setText(string);
            this.fTool.activate();
        }
    }

    private void setSelected(ToolButton toolButton) {
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.button().setSelected(false);
        }
        this.fSelectedToolButton = toolButton;
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.button().setSelected(true);
        }
    }

    public ToolButton toolButtonForTextFigure(TextFigure textFigure) {
        if (textFigure.parent() == null) {
            return this.fTextTB;
        }
        return this.fConnTextTB;
    }

    public void doTextEdit(TextFigure textFigure, int n, int n2) {
        ToolButton toolButton = this.toolButtonForTextFigure(textFigure);
        this.paletteUserSelected(toolButton, this.fToolButtonSticky);
        TextTool textTool = (TextTool)toolButton.tool();
        textTool.beginEdit(textFigure);
        if (n > 0 && n2 > 0) {
            textTool.setCaretPosition(n, n2);
        }
    }

    public void doTextEdit(TextFigure textFigure) {
        this.doTextEdit(textFigure, 0, 0);
    }

    protected void requestClose() {
        if (this.canClose()) {
            this.exit();
        }
    }

    public void exit() {
        Enumeration<DrawingViewContainer> enumeration;
        while ((enumeration = this.fViewContainers.elements()).hasMoreElements()) {
            DrawingViewContainer drawingViewContainer = enumeration.nextElement();
            this.destroyViewContainer(drawingViewContainer);
        }
        MenuManager.getInstance().unregisterMenu("CH.ifa.drawWindowsMenu and tools");
        this.destroy();
        this.toolFrame.setVisible(false);
        this.toolFrame.dispose();
        this.menuFrame.setVisible(false);
        this.menuFrame.dispose();
        if (--windowCount <= 0) {
            // empty if block
        }
    }

    public boolean canClose() {
        boolean bl = true;
        Enumeration<DrawingViewContainer> enumeration = new Vector<DrawingViewContainer>(this.fViewContainers).elements();
        while (bl && enumeration.hasMoreElements()) {
            DrawingViewContainer drawingViewContainer = enumeration.nextElement();
            bl = this.checkDrawingModifiedOnClose(drawingViewContainer);
        }
        return bl;
    }

    protected void destroy() {
    }

    public Drawing promptNew() {
        Drawing drawing = this.createDrawing();
        this.openDrawing(drawing);
        return drawing;
    }

    public Drawing promptChooseNew() {
        DrawingTypeManager drawingTypeManager = DrawingTypeManager.getInstance();
        Hashtable<String, SimpleFileFilter> hashtable = drawingTypeManager.getDrawingTypes();
        Set set = hashtable.keySet();
        String[] stringArray = set.toArray(new String[set.size()]);
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = ((SimpleFileFilter)hashtable.get(stringArray[i])).getDescription();
        }
        NewDrawingDialog newDrawingDialog = new NewDrawingDialog(DrawPlugin.getGui().getFrame(), stringArray2, 0);
        int n = newDrawingDialog.showDialog();
        if (n >= 0 && n < stringArray.length) {
            Drawing drawing = DrawingTypeManager.getDrawingFromName(stringArray[n]);
            this.openDrawing(drawing);
            return drawing;
        }
        return null;
    }

    public void promptOpen(FileFilter fileFilter) {
        File[] fileArray = this.getIOHelper().getLoadPath(null, fileFilter, true);
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileFilter instanceof SimpleFileFilter) {
                    fileArray[i] = DrawingFileHelper.checkAndAddExtension(fileArray[i], (SimpleFileFilter)fileFilter);
                }
                this.openOrLoadDrawing(fileArray[i]);
            }
        }
    }

    void promptOpenURL() {
        String string = "Type in URL:\n Accepted protocols are: http, file, jar.\nIf not specified I will try to use http.\nExamples:\nhttp://my.server.tld/referencenet.rnw.\n file:///my/path/to/nets/net.rnw.\njar:file:///my/path/to/jar/the.jar!/path/to/file/net.rnw";
        String string2 = JOptionPane.showInputDialog(DrawPlugin.getGui().getFrame(), (Object)string);
        if (string2 != null) {
            if (!(string2.startsWith("jar:") || string2.startsWith("file://") || string2.startsWith("http://"))) {
                string2 = "http://" + string2;
            }
            try {
                URL uRL = new URL(string2);
                logger.debug((Object)uRL);
                this.getIOHelper().loadAndOpenDrawing(uRL);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private IOHelper getIOHelper() {
        return DrawPlugin.getCurrent().getIOHelper();
    }

    protected void promptInsert() {
        SimpleFileFilter simpleFileFilter = this.drawing().getDefaultFileFilter();
        File file = this.getIOHelper().getLoadPath(null, simpleFileFilter);
        if ((file = DrawingFileHelper.checkAndAddExtension(file, simpleFileFilter)) != null) {
            this.loadAndInsertDrawing(file);
        }
    }

    protected void saveDrawingAs() {
        this.saveDrawingAs(this.drawing());
    }

    public void saveDrawingAs(Drawing drawing) {
        File file = drawing.getFilename();
        if (!this.promptSaveAs(drawing)) {
            this.showAndPrint("Could not save File: " + file);
        } else {
            file = drawing.getFilename();
            this.saveDrawing(drawing, file);
        }
    }

    public boolean saveDrawing(Drawing drawing) {
        File file = drawing.getFilename();
        if (file == null) {
            if (!this.promptSaveAs(drawing)) {
                return false;
            }
            file = drawing.getFilename();
        }
        this.saveDrawing(drawing, file);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(DrawApplication.class.getName() + ": saved drawing: " + file));
        }
        DrawPlugin.getCurrent().updateRecentlySavedList(file.getAbsolutePath());
        return true;
    }

    public void openOrLoadDrawing(File file) {
        Enumeration<Drawing> enumeration = this.drawings();
        while (enumeration.hasMoreElements()) {
            Drawing drawing = enumeration.nextElement();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(DrawApplication.class.getSimpleName() + ": checking equality of loaded drawings and newly opened drawing: " + drawing.getFilename()));
                logger.debug((Object)(DrawApplication.class.getSimpleName() + ": path = " + file.getAbsolutePath()));
            }
            if (drawing.getFilename() == null || !drawing.getFilename().getAbsoluteFile().equals(file.getAbsoluteFile())) continue;
            this.showDrawingViewContainer(drawing);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(DrawApplication.class.getSimpleName() + ": no matching drawing found proceeding with loadAndOpenDrawing " + file.getAbsolutePath()));
        }
        this.getIOHelper().loadAndOpenDrawing(file);
    }

    public void openOrLoadDrawing(String string) {
        this.openOrLoadDrawing(new File(string));
    }

    protected void saveDrawing(Drawing drawing, File file) {
        String string = " drawing " + drawing.getName() + " as " + file;
        this.showAndPrint("Saving" + string + "...");
        DrawingViewContainer drawingViewContainer = this.getViewContainer(drawing);
        PositionedDrawing positionedDrawing = new PositionedDrawing(drawingViewContainer.getLocation(), drawingViewContainer.getSize(), drawing);
        DrawingFileHelper.savePositionedDrawing(positionedDrawing, file, this);
        this.showStatus("Saved" + string + ".");
        this.autosaveManager.renameDrawing(drawing);
    }

    protected boolean promptSaveAs() {
        return this.promptSaveAs(this.drawing());
    }

    protected boolean promptSaveAs(Drawing drawing) {
        int n;
        SimpleFileFilter simpleFileFilter = drawing.getDefaultFileFilter();
        File file = drawing.getFilename();
        if (file == null) {
            file = new File(this.getIOHelper().getLastPath(), drawing.getName());
            file = DrawingFileHelper.checkAndAddExtension(file, simpleFileFilter);
        }
        this.toolDone();
        file = this.getIOHelper().getSavePath(file, simpleFileFilter);
        if (file == null) {
            return false;
        }
        if ((file = DrawingFileHelper.checkAndAddExtension(file, simpleFileFilter)).exists() && (n = JOptionPane.showConfirmDialog(this.getViewContainer(drawing).getFrame(), "The file \"" + file + "\"" + " does already exist." + "\nDo you want do proceed?", "Renew: Confirm overwrite.", 0)) >= 1) {
            return false;
        }
        this.updateName(drawing, file);
        drawing.setBackupStatus(false);
        return true;
    }

    public void print() {
        this.fTool.deactivate();
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this.view());
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                logger.debug((Object)printerException.getMessage(), (Throwable)printerException);
                JOptionPane.showMessageDialog(this.getFrame(), "Printing of this Drawing failed.\nReason: " + printerException.getMessage(), "Printer Error", 0);
            }
        }
        this.fTool.activate();
    }

    @Override
    public void saveAutosaveFile(Drawing drawing, File file, Point point, Dimension dimension) throws IOException {
        DrawingFileHelper.saveAsStorableOutput(drawing, file, point, dimension, false);
    }

    public void loadAndOpenCommandLineDrawings(final String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        DrawApplication.this.getIOHelper().loadAndOpenDrawing(new URL(stringArray[i]));
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        DrawApplication.this.openOrLoadDrawing(stringArray[i]);
                    }
                }
            }
        });
    }

    public void loadAndOpenCommandLineDrawing(final URL uRL) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DrawApplication.this.getIOHelper().loadAndOpenDrawing(uRL);
            }
        });
    }

    public synchronized void openDrawing(PositionedDrawing positionedDrawing) {
        if (positionedDrawing != null) {
            Drawing drawing = positionedDrawing.getDrawing();
            if (positionedDrawing.getWindowLocation() != null && positionedDrawing.getWindowDimension() != null) {
                this.newDrawingViewContainer(drawing, positionedDrawing.getWindowLocation(), positionedDrawing.getWindowDimension());
            } else {
                this.newDrawingViewContainer(drawing);
            }
            this.autosaveManager.addDrawing(drawing);
        }
    }

    public Drawing openDrawing(Drawing drawing) {
        this.newDrawingViewContainer(drawing);
        this.autosaveManager.addDrawing(drawing);
        return drawing;
    }

    public void loadInViewContainer(PositionedDrawing positionedDrawing) {
        this.newDrawingViewContainer(positionedDrawing.getDrawing(), positionedDrawing.getWindowLocation(), positionedDrawing.getWindowDimension());
        this.autosaveManager.addDrawing(positionedDrawing.getDrawing());
    }

    protected synchronized void loadAndInsertDrawing(File file) {
        Drawing drawing = this.drawing();
        DrawingView drawingView = this.view();
        Drawing drawing2 = DrawingFileHelper.loadDrawing(file, null);
        if (drawing2 != null) {
            FigureEnumeration figureEnumeration = drawing2.figures();
            drawingView.clearSelection();
            while (figureEnumeration.hasMoreElements()) {
                Figure figure = figureEnumeration.nextFigure();
                drawing.add(figure);
                drawingView.addToSelection(figure);
            }
            drawingView.checkDamage();
        }
    }

    @Override
    public void drawingViewContainerActivated(DrawingViewContainer drawingViewContainer) {
        if (drawingViewContainer != null && drawingViewContainer != this.fViewContainer) {
            this.setCurrentDrawing(drawingViewContainer);
        }
        if (GUIProperties.fixMenus()) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }
    }

    @Override
    public void drawingViewContainerClosing(DrawingViewContainer drawingViewContainer) {
        this.closeViewContainer(drawingViewContainer);
    }

    @Override
    public UndoRedoManager getUndoRedoManager() {
        return this.undoManager;
    }

    @Override
    public void prepareUndoSnapshot() {
        Drawing drawing = this.drawing();
        this.undoManager.prepareUndoSnapshot(drawing);
    }

    @Override
    public void commitUndoSnapshot() {
        Drawing drawing = this.drawing();
        this.undoManager.commitUndoSnapshot(drawing);
    }

    protected void noUndoHistoryFor(Drawing drawing) {
        this.undoManager.removeUndoHistory(drawing);
    }

    public boolean selectOffendingElements(FigureException figureException) {
        if (figureException.errorDrawing != null && !figureException.errorFigures.isEmpty()) {
            this.view().clearSelection();
            this.showDrawingViewContainer(figureException.errorDrawing);
            FigureEnumerator figureEnumerator = new FigureEnumerator(figureException.errorFigures);
            this.view().addToSelectionAll(figureEnumerator);
            this.view().repairDamage();
            if (figureException.textErrorFigure != null) {
                this.view().showElement(figureException.textErrorFigure);
                this.doTextEdit(figureException.textErrorFigure, figureException.line, figureException.column);
            }
            return true;
        }
        return false;
    }

    public static void main(final String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DrawApplication("JHotDraw", stringArray);
            }
        });
    }

    @Override
    public Dimension getSize() {
        return this.menuFrame.getSize();
    }

    @Override
    public Point getLocationOnScreen() {
        return this.menuFrame.getLocationOnScreen();
    }

    public static class DefaultDrawingViewContainerSupplier
    implements DrawingViewContainerSupplier {
        @Override
        public DrawingViewContainer getContainer(DrawApplication drawApplication, StandardDrawingView standardDrawingView, Drawing drawing, Point point, Dimension dimension) {
            return new DrawingViewFrame(drawApplication, standardDrawingView, drawing, point, dimension);
        }
    }
}

