/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.application.WindowsMenu;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.CommandMenuItem;
import de.renew.util.BinaryLoaderListener;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public class MenuManager {
    public static Logger logger = Logger.getLogger(MenuManager.class);
    public static final String ID_PROPERTY = "ch.ifa.draw.menu.id";
    private static MenuManager instance;
    private BinaryLoaderListener binaryLoaderListener;
    private HashMap<String, SeparatorFactory> separatorFactories;
    private HashMap<String, JMenu> toplevelMenus;
    private HashMap<String, JMenuItem> registeredMenus;
    private List<String> toplevelOrder = new Vector<String>();
    private DrawApplication application = null;
    private boolean windowsMenuPresent = false;
    private boolean helpMenuPresent = false;
    private HashMap<String, JMenuItem> tmpRegisteredMenuItems;

    private MenuManager() {
        this.toplevelMenus = new HashMap();
        this.registeredMenus = new HashMap();
        WindowsMenu windowsMenu = new WindowsMenu("Windows");
        this.toplevelMenus.put("Windows", windowsMenu);
        this.toplevelOrder.add("Windows");
        this.windowsMenuPresent = true;
    }

    public void setBinaryLoaderListener(BinaryLoaderListener binaryLoaderListener) {
        this.binaryLoaderListener = binaryLoaderListener;
        if (this.binaryLoaderListener != null && this.tmpRegisteredMenuItems != null) {
            for (String string : this.tmpRegisteredMenuItems.keySet()) {
                this.binaryLoaderListener.menuItemRegistered(string, this.tmpRegisteredMenuItems.get(string));
            }
            this.tmpRegisteredMenuItems.clear();
            this.tmpRegisteredMenuItems = null;
        }
    }

    public void unsetBinaryLoaderListener(BinaryLoaderListener binaryLoaderListener) {
        this.binaryLoaderListener = null;
    }

    public static MenuManager getInstance() {
        if (instance == null) {
            instance = new MenuManager();
        }
        return instance;
    }

    public synchronized void registerMenu(String string, JMenuItem jMenuItem) {
        JMenu jMenu = this.toplevelMenus.get(string);
        String string2 = (String)jMenuItem.getClientProperty(ID_PROPERTY);
        if (string2 == null) {
            logger.error((Object)(this.getClass() + ": could not register menu " + jMenuItem + ": please set " + ID_PROPERTY + " with menu.setClientProperty()."));
            return;
        }
        if (jMenu == null) {
            int n;
            logger.debug((Object)(this.getClass() + ": creating new top level menu " + string));
            if (string.equals("Windows")) {
                throw new RuntimeException("Windows menu should be always present, but is not available!");
            }
            if (string.equals("Help")) {
                jMenu = new CommandMenu(string);
                n = this.toplevelOrder.size();
                this.helpMenuPresent = true;
            } else {
                jMenu = new CommandMenu(string);
                n = this.toplevelOrder.size() - (this.helpMenuPresent ? 1 : 0) - (this.windowsMenuPresent ? 1 : 0);
            }
            this.toplevelMenus.put(string, jMenu);
            this.toplevelOrder.add(n, string);
            if (this.application != null) {
                this.application.addMenu(jMenu, n);
            }
        }
        if (jMenuItem instanceof SeparatorItem) {
            this.registeredMenus.put(string2, jMenuItem);
            jMenu.addSeparator();
        } else {
            this.registeredMenus.put(string2, jMenuItem);
            jMenu.add(jMenuItem);
        }
        logger.debug((Object)(this.getClass() + ": the menu " + jMenuItem.getText() + " has been registered under " + string + ", id " + jMenuItem.getClientProperty(ID_PROPERTY)));
        if (this.binaryLoaderListener != null) {
            this.binaryLoaderListener.menuItemRegistered(string2, jMenuItem);
        } else {
            if (this.tmpRegisteredMenuItems == null) {
                this.tmpRegisteredMenuItems = new HashMap();
            }
            this.tmpRegisteredMenuItems.put(string2, jMenuItem);
        }
    }

    public synchronized void registerMenu(String string, JPopupMenu.Separator separator) {
        JMenu jMenu = this.toplevelMenus.get(string);
        String string2 = (String)separator.getClientProperty(ID_PROPERTY);
        if (string2 == null) {
            logger.error((Object)(this.getClass() + ": could not register separator " + separator + ": please set " + ID_PROPERTY + " with menu.setClientProperty()."));
            return;
        }
        if (jMenu != null) {
            jMenu.addSeparator();
        } else {
            logger.error((Object)("Could not register separator with " + string2 + ". Parent menu " + string + " not found!"));
        }
    }

    public synchronized void registerMenu(String string, JMenuItem jMenuItem, int n) {
        SeparatorFactory separatorFactory = this.getFactory(string);
        if (n == 0) {
            this.registerMenu(string, separatorFactory.createJPopupMenuSeparator(jMenuItem.getClientProperty(ID_PROPERTY)));
        }
        this.registerMenu(string, jMenuItem);
        if (n == 1) {
            this.registerMenu(string, separatorFactory.createJPopupMenuSeparator(jMenuItem.getClientProperty(ID_PROPERTY)));
        }
    }

    public void registerMenu(String string, JMenuItem jMenuItem, String string2) {
        jMenuItem.putClientProperty(ID_PROPERTY, string2);
        this.registerMenu(string, jMenuItem);
    }

    public synchronized void registerMenu(String string, JMenuItem jMenuItem, int n, int n2) {
        if (n == 0 || n2 > 2 || n2 < 0) {
            logger.error((Object)(this.getClass().getSimpleName() + ": could not register menu item " + jMenuItem.getText() + "\nparameter 'where' must be  0 < where < 3 and sections start with 1"));
            return;
        }
        JMenu jMenu = this.toplevelMenus.get(string);
        String string2 = (String)jMenuItem.getClientProperty(ID_PROPERTY);
        if (string2 == null || jMenu == null) {
            logger.error((Object)(this.getClass().getSimpleName() + ": could not register menu item " + jMenuItem.getText() + (string2 == null ? ": please set ch.ifa.draw.menu.id with menu.setClientProperty()." : " toplevel menu " + string + " does not exist")));
            return;
        }
        this.registeredMenus.put(string2, jMenuItem);
        Component[] componentArray = jMenu.getMenuComponents();
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        boolean bl = false;
        while (n3 < componentArray.length && n4 <= n) {
            if (n4 == n) {
                if (n2 == 0) {
                    jMenu.add((Component)jMenuItem, n3);
                    break;
                }
                if (bl) {
                    if (n2 == 1) {
                        jMenu.add((Component)jMenuItem, n3 + 1);
                        break;
                    }
                    if (n2 != 2) break;
                    jMenu.add((Component)jMenuItem, n5 / 2 + (n3 + 1 - n5));
                    break;
                }
            }
            if (componentArray[n3] instanceof JPopupMenu.Separator) {
                ++n4;
                n5 = 0;
            }
            if (n3 + 1 == componentArray.length) {
                jMenu.add(jMenuItem);
            }
            ++n5;
            bl = ++n3 + 1 >= componentArray.length || componentArray[n3 + 1] instanceof JPopupMenu.Separator;
        }
        logger.debug((Object)(this.getClass() + ": the menu " + jMenuItem.getText() + " has been registered under " + string + ", id " + jMenuItem.getClientProperty(ID_PROPERTY) + "\n" + this.registeredMenus.get(string2).getText()));
        if (this.binaryLoaderListener != null) {
            this.binaryLoaderListener.menuItemRegistered(string2, jMenuItem);
        } else {
            if (this.tmpRegisteredMenuItems == null) {
                this.tmpRegisteredMenuItems = new HashMap();
            }
            this.tmpRegisteredMenuItems.put(string2, jMenuItem);
        }
    }

    public void unregisterMenu(JMenuItem jMenuItem) {
        if (jMenuItem instanceof SeparatorItem) {
            logger.debug((Object)(this.getClass() + ": no need to unregister separator."));
            return;
        }
        String string = (String)jMenuItem.getClientProperty(ID_PROPERTY);
        if (string == null) {
            logger.debug((Object)(this.getClass() + " unregistering item " + jMenuItem.getText() + ": no client property set!"));
            return;
        }
        this.unregisterMenu(string);
    }

    public void unregisterMenu(JMenuItem jMenuItem, int n) {
        String string = (String)jMenuItem.getClientProperty(ID_PROPERTY);
        if (string == null) {
            logger.debug((Object)(this.getClass() + " unregistering item " + jMenuItem.getText() + ": no client property set!"));
            return;
        }
        this.unregisterMenu(string, n);
    }

    public synchronized void unregisterMenu(String string) {
        AbstractButton abstractButton = null;
        Iterator<JMenu> iterator = this.toplevelMenus.values().iterator();
        AbstractButton abstractButton2 = null;
        block0: while (abstractButton == null && iterator.hasNext()) {
            JMenu jMenu = iterator.next();
            Component[] componentArray = jMenu.getMenuComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                JMenuItem jMenuItem;
                String string2;
                if (!(componentArray[i] instanceof JMenuItem) || !string.equals(string2 = (String)(jMenuItem = (JMenuItem)componentArray[i]).getClientProperty(ID_PROPERTY))) continue;
                abstractButton = jMenu;
                abstractButton2 = jMenuItem;
                continue block0;
            }
        }
        if (abstractButton2 == null) {
            logger.debug((Object)(this.getClass() + ".unregisterMenu(): menu " + string + " not found!"));
            return;
        }
        logger.debug((Object)(this.getClass() + ": unregistering menu " + abstractButton2.getText() + " from " + (abstractButton != null ? abstractButton.getText() : "[ERROR: JMenu 'topLevel' not set!]")));
        if (abstractButton != null) {
            ((JMenu)abstractButton).remove((JMenuItem)abstractButton2);
            while (((JMenu)abstractButton).getItemCount() > 0 && ((JMenu)abstractButton).getItem(0) == null) {
                logger.debug((Object)(this.getClass() + ": removing top separator."));
                ((JMenu)abstractButton).remove(0);
            }
            while (((JMenu)abstractButton).getItemCount() > 0 && ((JMenu)abstractButton).getItem(((JMenu)abstractButton).getItemCount() - 1) == null) {
                logger.debug((Object)(this.getClass() + ": removing top separator."));
                ((JMenu)abstractButton).remove(((JMenu)abstractButton).getItemCount() - 1);
            }
            this.removeMenuIfEmpty(abstractButton.getText(), (JMenu)abstractButton);
        }
        this.registeredMenus.remove(abstractButton2.getClientProperty(ID_PROPERTY));
    }

    public synchronized void unregisterMenu(String string, int n) {
        AbstractButton abstractButton = null;
        Iterator<JMenu> iterator = this.toplevelMenus.values().iterator();
        AbstractButton abstractButton2 = null;
        JPopupMenu.Separator separator = null;
        block0: while (abstractButton == null && iterator.hasNext()) {
            JMenu jMenu = iterator.next();
            Component[] componentArray = jMenu.getMenuComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component;
                JMenuItem jMenuItem;
                String string2;
                if (!(componentArray[i] instanceof JMenuItem) || !string.equals(string2 = (String)(jMenuItem = (JMenuItem)componentArray[i]).getClientProperty(ID_PROPERTY))) continue;
                abstractButton = jMenu;
                abstractButton2 = jMenuItem;
                if (i - 1 >= 0 && n == 0 && (component = componentArray[i - 1]) instanceof JPopupMenu.Separator) {
                    separator = (JPopupMenu.Separator)component;
                }
                if (i + 1 >= componentArray.length || n != 1 || !((component = componentArray[i + 1]) instanceof JPopupMenu.Separator)) continue block0;
                separator = (JPopupMenu.Separator)component;
                continue block0;
            }
        }
        if (abstractButton2 == null) {
            logger.debug((Object)(this.getClass() + ".unregisterMenu(): menu " + string + " not found! Check registeredMenus instead..."));
            return;
        }
        logger.debug((Object)(this.getClass() + ": unregistering menu " + abstractButton2.getText() + " from " + (abstractButton != null ? abstractButton.getText() : "[ERROR: JMenu 'topLevel' not set!]")));
        if (abstractButton != null) {
            ((JMenu)abstractButton).remove((JMenuItem)abstractButton2);
            if (separator != null) {
                ((JMenu)abstractButton).remove(separator);
            }
            while (((JMenu)abstractButton).getItemCount() > 0 && ((JMenu)abstractButton).getItem(0) == null) {
                logger.debug((Object)(this.getClass() + ": removing top separator."));
                ((JMenu)abstractButton).remove(0);
            }
            while (((JMenu)abstractButton).getItemCount() > 0 && ((JMenu)abstractButton).getItem(((JMenu)abstractButton).getItemCount() - 1) == null) {
                logger.debug((Object)(this.getClass() + ": removing top separator."));
                ((JMenu)abstractButton).remove(((JMenu)abstractButton).getItemCount() - 1);
            }
            this.removeMenuIfEmpty(abstractButton.getText(), (JMenu)abstractButton);
        }
        this.registeredMenus.remove(abstractButton2.getClientProperty(ID_PROPERTY));
    }

    private void removeMenuIfEmpty(String string, JMenu jMenu) {
        if ("Windows".equals(string)) {
            return;
        }
        if (jMenu.getMenuComponentCount() == 0) {
            logger.debug((Object)(this.getClass() + ": the last MenuItem of menu " + string + " has been removed, removing menu"));
            if (this.application != null) {
                this.application.removeMenu(jMenu);
            }
            this.toplevelMenus.remove(string);
            this.toplevelOrder.remove(string);
            if ("Help".equals(string)) {
                this.helpMenuPresent = false;
            }
        }
    }

    void setGui(DrawApplication drawApplication) {
        this.application = drawApplication;
        if (this.application != null) {
            logger.debug((Object)(this.getClass() + ": adding menus to application object " + drawApplication));
            for (String string : this.toplevelOrder) {
                JMenu jMenu = this.toplevelMenus.get(string);
                this.application.addMenu(jMenu);
            }
        }
    }

    public static JMenuItem createSeparator(String string) {
        return new SeparatorItem(string);
    }

    JMenu getToplevelMenu(String string) {
        return this.toplevelMenus.get(string);
    }

    public WindowsMenu getWindowsMenu() {
        return (WindowsMenu)this.getToplevelMenu("Windows");
    }

    public static CommandMenuItem createMenuItem(Command command, int n) {
        CommandMenuItem commandMenuItem = new CommandMenuItem(command, n);
        return commandMenuItem;
    }

    private SeparatorFactory getFactory(String string) {
        SeparatorFactory separatorFactory = null;
        if (this.separatorFactories == null) {
            this.separatorFactories = new HashMap();
        }
        if (this.separatorFactories.containsKey(string)) {
            separatorFactory = this.separatorFactories.get(string);
        }
        if (!this.separatorFactories.containsKey(string)) {
            separatorFactory = new SeparatorFactory(string);
            this.separatorFactories.put(string, separatorFactory);
        }
        return separatorFactory;
    }

    public static class SeparatorFactory {
        public static final int _SEPARATOR_ABOVE = 0;
        public static final int _SEPARATOR_BELOW = 1;
        private int count;
        private String id;

        public SeparatorFactory(String string) {
            this.id = string;
        }

        public JMenuItem createSeparator() {
            SeparatorItem separatorItem = new SeparatorItem(this.id + ".sep" + this.count);
            separatorItem.putClientProperty(MenuManager.ID_PROPERTY, this.id + ".sep" + this.count++);
            return separatorItem;
        }

        public JPopupMenu.Separator createJPopupMenuSeparator(Object object) {
            JPopupMenu.Separator separator = new JPopupMenu.Separator();
            separator.putClientProperty(MenuManager.ID_PROPERTY, this.id + "." + object + ".separator");
            return separator;
        }

        public String getId() {
            return this.id;
        }
    }

    private static class SeparatorItem
    extends JMenuItem {
        public SeparatorItem(String string) {
            super(string);
        }
    }
}

