/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.FloatingTextField;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class TextTool
extends CreationTool {
    protected FloatingTextField fTextField;
    private TextHolder fTypingTarget;

    public TextTool(DrawingEditor drawingEditor, TextFigure textFigure) {
        super(drawingEditor, textFigure);
    }

    @Override
    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        TextHolder textHolder = null;
        Figure figure = this.drawing().findFigureInside(n, n2);
        if (figure instanceof TextHolder && !(textHolder = (TextHolder)((Object)figure)).acceptsTyping()) {
            textHolder = null;
        }
        if (textHolder != null) {
            this.beginEdit(textHolder);
            return;
        }
        if (this.fTypingTarget != null) {
            this.endEdit();
            this.editor().toolDone();
        } else {
            super.mouseDown(mouseEvent, n, n2);
            textHolder = (TextHolder)((Object)this.createdFigure());
            this.beginEdit(textHolder);
        }
    }

    @Override
    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
    }

    @Override
    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.endEdit();
    }

    @Override
    public void activate() {
        super.activate();
    }

    protected boolean isTypingActive() {
        return this.fTypingTarget != null;
    }

    public void beginEdit(TextHolder textHolder) {
        if (this.fTextField == null) {
            this.fTextField = new FloatingTextField();
            this.fTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 10) {
                        TextTool.this.deactivate();
                        TextTool.this.editor().toolDone();
                    }
                }
            });
        }
        if (textHolder != this.fTypingTarget && this.fTypingTarget != null) {
            this.endEdit();
        }
        this.fTextField.setText(textHolder.getText());
        this.fTextField.createOverlay((Container)((Object)this.view()), this.fieldBounds(textHolder), textHolder.getFont());
        this.fTypingTarget = textHolder;
    }

    public void setCaretPosition(int n, int n2) {
        this.fTextField.setCaretPosition(n, n2);
    }

    public void endEdit() {
        if (this.fTypingTarget != null) {
            String string = this.fTextField.getText();
            String string2 = this.fTypingTarget.getText();
            this.fTypingTarget.setText(string);
            if (string.trim().length() == 0) {
                this.drawing().remove((Figure)((Object)this.fTypingTarget));
            }
            this.fTypingTarget = null;
            this.fTextField.endOverlay();
            this.view().checkDamage();
            if (!string2.equals(string)) {
                this.changesMade();
                this.intermediateUndoSnapshot();
            } else {
                this.noChangesMade();
            }
        }
    }

    private Rectangle fieldBounds(TextHolder textHolder) {
        Rectangle rectangle = textHolder.textDisplayBox();
        return rectangle;
    }
}

