/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.framework;

import CH.ifa.draw.framework.Figure;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FigureSelection {
    public static Logger logger = Logger.getLogger(FigureSelection.class);
    public static final String TYPE = "CH.ifa.draw.Figures";
    private byte[] fData;

    public FigureSelection(Vector<Figure> vector) {
        this.fData = this.writeData(vector);
    }

    public FigureSelection(Enumeration<Figure> enumeration) {
        Vector<Figure> vector = new Vector<Figure>();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        this.fData = this.writeData(vector);
    }

    private byte[] writeData(Vector<Figure> vector) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(200);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeInt(vector.size());
            Enumeration<Figure> enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Figure figure = enumeration.nextElement();
                objectOutputStream.writeObject(figure);
            }
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            logger.error((Object)("Figure serialization failed: " + iOException + "\n"));
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String getType() {
        return TYPE;
    }

    public Vector<Figure> getData(String string) {
        if (string.equals(TYPE)) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.fData);
            Vector<Figure> vector = new Vector<Figure>(10);
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                int n = objectInputStream.readInt();
                for (int i = 0; i < n; ++i) {
                    Figure figure = (Figure)objectInputStream.readObject();
                    vector.addElement(figure);
                }
                objectInputStream.close();
            }
            catch (IOException iOException) {
                logger.error((Object)("Figure deserialization failed: " + iOException));
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.error((Object)("Figure deserialization failed: " + classNotFoundException));
            }
            return vector;
        }
        return null;
    }
}

