/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.framework;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.SnapshotHistory;
import java.util.Hashtable;

public class UndoRedoManager {
    private static final int UNDOSTEPS = 10;
    private Hashtable<Drawing, SnapshotHistory> undoHistoryTable = new Hashtable();
    private Hashtable<Drawing, SnapshotHistory> redoHistoryTable = new Hashtable();
    private DrawingEditor editor;

    public UndoRedoManager(DrawingEditor drawingEditor) {
        this.editor = drawingEditor;
    }

    public void prepareUndoSnapshot(Drawing drawing) {
        SnapshotHistory snapshotHistory = this.getUndoHistory(drawing);
        if (snapshotHistory != null) {
            snapshotHistory.prepareSnapshot();
        }
    }

    public void commitUndoSnapshot(Drawing drawing) {
        SnapshotHistory snapshotHistory = this.getUndoHistory(drawing);
        SnapshotHistory snapshotHistory2 = this.getRedoHistory(drawing);
        if (snapshotHistory != null) {
            snapshotHistory.commitSnapshot();
            snapshotHistory2.clear();
            this.editor.menuStateChanged();
        }
    }

    public void restoreUndoSnapshot(Drawing drawing) {
        SnapshotHistory snapshotHistory = this.getUndoHistory(drawing);
        SnapshotHistory snapshotHistory2 = this.getRedoHistory(drawing);
        if (snapshotHistory != null) {
            if (!snapshotHistory.isEmpty()) {
                snapshotHistory2.takeSnapshot();
                snapshotHistory.restoreSnapshot();
                this.editor.showStatus("Undone.");
            } else {
                this.editor.showStatus("Nothing to undo.");
            }
        }
    }

    public void restoreRedoSnapshot(Drawing drawing) {
        SnapshotHistory snapshotHistory = this.getUndoHistory(drawing);
        SnapshotHistory snapshotHistory2 = this.getRedoHistory(drawing);
        if (snapshotHistory2 != null) {
            if (!snapshotHistory2.isEmpty()) {
                snapshotHistory.takeSnapshot();
                snapshotHistory2.restoreSnapshot();
                this.editor.showStatus("Redone.");
            } else {
                this.editor.showStatus("Nothing to redo.");
            }
        }
    }

    public SnapshotHistory getUndoHistory(Drawing drawing) {
        return this.undoHistoryTable.get(drawing);
    }

    public SnapshotHistory getRedoHistory(Drawing drawing) {
        return this.redoHistoryTable.get(drawing);
    }

    public void clearUndoHistory(Drawing drawing) {
        SnapshotHistory snapshotHistory = this.undoHistoryTable.get(drawing);
        SnapshotHistory snapshotHistory2 = this.redoHistoryTable.get(drawing);
        if (snapshotHistory != null) {
            snapshotHistory.clear();
            snapshotHistory2.clear();
            this.editor.menuStateChanged();
        }
    }

    public void newUndoHistory(Drawing drawing) {
        SnapshotHistory snapshotHistory = this.undoHistoryTable.get(drawing);
        if (snapshotHistory == null) {
            this.undoHistoryTable.put(drawing, new SnapshotHistory(drawing, 10));
            this.redoHistoryTable.put(drawing, new SnapshotHistory(drawing, 10));
        }
    }

    public void removeUndoHistory(Drawing drawing) {
        this.undoHistoryTable.remove(drawing);
        this.redoHistoryTable.remove(drawing);
        this.editor.menuStateChanged();
    }
}

