/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.io;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.io.PositionedDrawing;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.StorableInputDrawingLoader;
import CH.ifa.draw.io.importFormats.ImportFormat;
import CH.ifa.draw.util.StorableOutput;
import de.renew.util.StringUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Logger;

public class DrawingFileHelper {
    public static Logger logger = Logger.getLogger(DrawingFileHelper.class);
    public static final int FILEVERSION = 11;
    private static StorableInputDrawingLoader loader = new StorableInputDrawingLoader();

    private DrawingFileHelper() {
    }

    public static Drawing loadDrawing(File file, StatusDisplayer statusDisplayer) {
        PositionedDrawing positionedDrawing = DrawingFileHelper.loadPositionedDrawing(file, statusDisplayer);
        if (positionedDrawing != null) {
            return positionedDrawing.getDrawing();
        }
        return null;
    }

    public static Drawing loadDrawing(InputStream inputStream, String string) throws FileNotFoundException, IOException {
        PositionedDrawing positionedDrawing = DrawingFileHelper.loadPositionedDrawing(inputStream, string);
        if (positionedDrawing != null) {
            return positionedDrawing.getDrawing();
        }
        return null;
    }

    public static Drawing loadDrawing(URL uRL, StatusDisplayer statusDisplayer) {
        PositionedDrawing positionedDrawing = DrawingFileHelper.loadPositionedDrawing(uRL, statusDisplayer);
        if (positionedDrawing != null) {
            return positionedDrawing.getDrawing();
        }
        return null;
    }

    public static PositionedDrawing loadPositionedDrawing(File file, StatusDisplayer statusDisplayer) {
        if (statusDisplayer == null) {
            statusDisplayer = DrawPlugin.getGui();
        }
        try {
            Drawing drawing = null;
            URL uRL = file.toURI().toURL();
            PositionedDrawing positionedDrawing = DrawingFileHelper.loadPositionedDrawing(uRL, statusDisplayer);
            if (positionedDrawing != null && (drawing = positionedDrawing.getDrawing()) != null) {
                drawing.setFilename(file);
            }
            return positionedDrawing;
        }
        catch (IOException iOException) {
            statusDisplayer.showStatus("Error " + iOException);
            return null;
        }
    }

    public static PositionedDrawing loadPositionedDrawing(InputStream inputStream, String string) throws FileNotFoundException, IOException {
        Drawing drawing;
        logger.debug((Object)("Loading drawing from " + inputStream + "..."));
        PositionedDrawing positionedDrawing = loader.readFromStorableInput(inputStream);
        if (positionedDrawing != null && (drawing = positionedDrawing.getDrawing()) != null) {
            drawing.setName(string);
            if (drawing instanceof Figure) {
                ((Figure)((Object)drawing)).invalidate();
            }
        }
        return positionedDrawing;
    }

    public static PositionedDrawing loadPositionedDrawing(URL uRL, StatusDisplayer statusDisplayer) {
        Object object;
        Object object2;
        logger.debug((Object)("Loading drawing from " + uRL + "..."));
        if (statusDisplayer == null) {
            statusDisplayer = DrawPlugin.getGui();
        }
        if (DrawPlugin.getCurrent() != null) {
            object = object2 = DrawPlugin.getCurrent().getImportHolder().allImportFormats();
            int n = ((ImportFormat[])object).length;
            for (int i = 0; i < n; ++i) {
                ImportFormat importFormat = object[i];
                if (!importFormat.canImport(uRL)) continue;
                try {
                    Drawing[] drawingArray = importFormat.importFiles(new URL[]{uRL});
                    if (drawingArray.length > 0) {
                        PositionedDrawing positionedDrawing = new PositionedDrawing(null, null, drawingArray[0]);
                        return positionedDrawing;
                    }
                    continue;
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage());
                    logger.debug((Object)exception);
                }
            }
        }
        try {
            object2 = loader.readFromStorableInput(uRL, statusDisplayer);
            if (object2 != null && (object = ((PositionedDrawing)object2).getDrawing()) != null) {
                object.setName(StringUtil.getFilename((String)uRL.getFile()));
                if (object instanceof Figure) {
                    ((Figure)object).invalidate();
                }
            }
            return object2;
        }
        catch (IOException iOException) {
            logger.error((Object)("Could not open Drawing: " + uRL.toString()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(DrawingFileHelper.class.getSimpleName() + ": " + iOException));
            }
            statusDisplayer.showStatus("Error " + iOException);
            return null;
        }
    }

    public static File deriveBackupFile(File file) {
        File file2 = new File(file.getParent(), StringUtil.stripFilenameExtension((String)file.getName()) + ".bak");
        if (file2.equals(file)) {
            return null;
        }
        return file2;
    }

    public static boolean saveDrawing(Drawing drawing, File file, StatusDisplayer statusDisplayer) {
        return DrawingFileHelper.savePositionedDrawing(new PositionedDrawing(null, null, drawing), file, statusDisplayer);
    }

    public static boolean savePositionedDrawing(PositionedDrawing positionedDrawing, File file, StatusDisplayer statusDisplayer) {
        File file2;
        Drawing drawing = positionedDrawing.getDrawing();
        if (!drawing.getBackupStatus() && (file2 = DrawingFileHelper.deriveBackupFile(file)) != null && file.exists()) {
            logger.debug((Object)("Creating backup file " + file2 + "..."));
            if (file.renameTo(file2)) {
                drawing.setBackupStatus(true);
            } else {
                logger.error((Object)("Could not create backup file " + file2 + "!"));
                logger.error((Object)("Original filename is " + file));
            }
        }
        logger.debug((Object)("Saving drawing as " + file + "..."));
        try {
            DrawingFileHelper.saveAsStorableOutput(drawing, file, positionedDrawing.getWindowLocation(), positionedDrawing.getWindowDimension(), true);
            return true;
        }
        catch (IOException iOException) {
            statusDisplayer.showStatus("Error " + iOException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsStorableOutput(Drawing drawing, File file, Point point, Dimension dimension, boolean bl) throws IOException {
        drawing.lock();
        try {
            StorableOutput storableOutput = new StorableOutput(file);
            storableOutput.writeInt(11);
            storableOutput.writeStorable(drawing);
            if (point != null && dimension != null) {
                storableOutput.writeInt(point.x);
                storableOutput.writeInt(point.y);
                storableOutput.writeInt(dimension.width);
                storableOutput.writeInt(dimension.height);
            }
            storableOutput.close();
            if (bl) {
                drawing.clearModified();
            }
        }
        finally {
            drawing.unlock();
        }
    }

    public static File checkAndAddExtension(File file, SimpleFileFilter simpleFileFilter) {
        File file2 = file;
        if (file != null && simpleFileFilter != null && !simpleFileFilter.accept(file)) {
            file2 = new File(file.getParentFile(), file.getName() + "." + simpleFileFilter.getExtension());
        }
        return file2;
    }

    public static void setStorableInputDrawingLoader(StorableInputDrawingLoader storableInputDrawingLoader) {
        if (storableInputDrawingLoader == null) {
            throw new NullPointerException("Cannot set null reference as loader.");
        }
        loader = storableInputDrawingLoader;
    }
}

