/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.io;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.PositionedDrawing;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.util.KnownPlugins;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.UnknownTypeException;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class StorableInputDrawingLoader {
    private static Logger logger = Logger.getLogger(StorableInputDrawingLoader.class);

    protected StorableInput makeStorableInput(URL uRL, boolean bl) throws IOException {
        return new StorableInput(uRL, bl);
    }

    protected StorableInput makeStorableInput(InputStream inputStream, boolean bl) {
        return new StorableInput(inputStream, bl);
    }

    public PositionedDrawing readFromStorableInput(File file, StatusDisplayer statusDisplayer) throws IOException {
        try {
            return this.readFromStorableInput(file.toURI().toURL(), statusDisplayer);
        }
        catch (MalformedURLException malformedURLException) {
            statusDisplayer.showStatus("Error " + malformedURLException);
            return null;
        }
    }

    public PositionedDrawing readFromStorableInput(InputStream inputStream) throws FileNotFoundException, IOException {
        StorableInput storableInput = null;
        storableInput = this.makeStorableInput(inputStream, true);
        return this.readFromStorableInput(storableInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PositionedDrawing readFromStorableInput(URL uRL, StatusDisplayer statusDisplayer) throws IOException {
        try (StorableInput storableInput = null;){
            storableInput = this.makeStorableInput(uRL, true);
            PositionedDrawing positionedDrawing = this.readFromStorableInput(storableInput, statusDisplayer);
            return positionedDrawing;
        }
    }

    private PositionedDrawing readFromStorableInput(StorableInput storableInput, StatusDisplayer statusDisplayer) {
        Drawing drawing = null;
        Point point = null;
        Dimension dimension = null;
        try {
            drawing = StorableInputDrawingLoader.readStorableDrawing(storableInput);
            if (storableInput.canReadInt()) {
                point = new Point(storableInput.readInt(), storableInput.readInt());
                dimension = new Dimension(storableInput.readInt(), storableInput.readInt());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            statusDisplayer.showStatus("Error: File not found. " + fileNotFoundException);
        }
        catch (IOException iOException) {
            logger.error((Object)("Could not open Drawing: " + storableInput.getURI().toString()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(DrawingFileHelper.class.getSimpleName() + ": " + iOException));
            }
            if (iOException instanceof UnknownTypeException) {
                UnknownTypeException unknownTypeException = (UnknownTypeException)iOException;
                String string = KnownPlugins.guessPluginByClass(unknownTypeException.getType());
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Error:\n");
                stringBuilder.append("Could not open Drawing:\n");
                try {
                    stringBuilder.append(URLDecoder.decode(storableInput.getURI().toString(), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    stringBuilder.append(storableInput.getURI().toString());
                }
                stringBuilder.append("\n\n");
                stringBuilder.append("There might be a plugin missing.");
                if (string != null) {
                    stringBuilder.append("\n");
                    stringBuilder.append("Try to install the plugin: ");
                    stringBuilder.append(string);
                }
                String string2 = stringBuilder.toString();
                JOptionPane.showMessageDialog(null, string2, "Error: Could not open Drawing", -1);
            }
            statusDisplayer.showStatus("Error: Could not open Drawing.");
        }
        if (drawing == null) {
            return null;
        }
        return new PositionedDrawing(point, dimension, drawing);
    }

    private PositionedDrawing readFromStorableInput(StorableInput storableInput) throws FileNotFoundException, IOException {
        Drawing drawing = null;
        Point point = null;
        Dimension dimension = null;
        try {
            drawing = StorableInputDrawingLoader.readStorableDrawing(storableInput);
            if (storableInput.canReadInt()) {
                point = new Point(storableInput.readInt(), storableInput.readInt());
                dimension = new Dimension(storableInput.readInt(), storableInput.readInt());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = "StorableInputDrawingLoader.readFromStorableInput : Error: File not found. " + fileNotFoundException;
            throw new FileNotFoundException(string);
        }
        catch (IOException iOException) {
            String string = "StorableInputDrawingLoader.readFromStorableInput : Error " + iOException;
            throw new IOException(string);
        }
        if (drawing == null) {
            return null;
        }
        return new PositionedDrawing(point, dimension, drawing);
    }

    public static Drawing readStorableDrawing(StorableInput storableInput) throws IOException {
        if (storableInput.canReadInt()) {
            storableInput.setVersion(storableInput.readInt());
        } else {
            storableInput.setVersion(0);
        }
        return (Drawing)storableInput.readStorable();
    }
}

